/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.jdbc;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.jdbc.BytesConverter;
import com.navercorp.pinpoint.profiler.jdbc.ClassNameConverter;
import com.navercorp.pinpoint.profiler.jdbc.Converter;
import com.navercorp.pinpoint.profiler.jdbc.HexBytesConverter;
import com.navercorp.pinpoint.profiler.jdbc.NullTypeConverter;
import com.navercorp.pinpoint.profiler.jdbc.ObjectConverter;
import com.navercorp.pinpoint.profiler.jdbc.SimpleTypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class BindValueConverter {
    static final int DEFAULT_ABBREVIATE_MAX_WIDTH = 32;
    private final int maxWidth;
    private final Map<String, Converter> converterMap = new HashMap<String, Converter>();
    private final ClassNameConverter classNameConverter;
    private final BytesConverter bytesConverter;
    private final HexBytesConverter hexBytesConverter;
    private final ObjectConverter objectConverter;
    private final NullTypeConverter nullTypeConverter;
    private final SimpleTypeConverter simpleTypeConverter;

    public static BindValueConverter defaultBindValueConverter() {
        return BindValueConverter.defaultBindValueConverter(32);
    }

    public static BindValueConverter defaultBindValueConverter(int maxWidth) {
        BindValueConverter converter = new BindValueConverter(maxWidth);
        converter.simpleType();
        converter.classNameType();
        converter.setNullConverter();
        converter.setHexBytesConverter();
        converter.setObjectConverter();
        return converter;
    }

    public BindValueConverter() {
        this(32);
    }

    public BindValueConverter(int maxWidth) {
        this.maxWidth = maxWidth;
        Assert.isTrue((maxWidth > 0 ? 1 : 0) != 0, (String)"negative abbreviateMaxWidth");
        this.classNameConverter = new ClassNameConverter();
        this.bytesConverter = new BytesConverter(this.maxWidth);
        this.hexBytesConverter = new HexBytesConverter(this.maxWidth);
        this.objectConverter = new ObjectConverter(this.maxWidth);
        this.nullTypeConverter = new NullTypeConverter();
        this.simpleTypeConverter = new SimpleTypeConverter(this.maxWidth);
    }

    private void register(String methodName, Converter converter) {
        this.converterMap.put(methodName, converter);
    }

    private void classNameType() {
        this.register("setAsciiStream", this.classNameConverter);
        this.register("setUnicodeStream", this.classNameConverter);
        this.register("setBinaryStream", this.classNameConverter);
        this.register("setBlob", this.classNameConverter);
        this.register("setClob", this.classNameConverter);
        this.register("setArray", this.classNameConverter);
        this.register("setNCharacterStream", this.classNameConverter);
        this.register("setNClob", this.classNameConverter);
        this.register("setCharacterStream", this.classNameConverter);
        this.register("setSQLXML", this.classNameConverter);
    }

    public void setRawBytesConverter() {
        this.register("setBytes", this.bytesConverter);
    }

    public void setHexBytesConverter() {
        this.register("setBytes", this.hexBytesConverter);
    }

    private void setObjectConverter() {
        this.register("setObject", this.objectConverter);
    }

    private void setNullConverter() {
        this.register("setNull", new NullTypeConverter());
    }

    private void simpleType() {
        SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter(this.maxWidth);
        this.register("setByte", simpleTypeConverter);
        this.register("setBoolean", simpleTypeConverter);
        this.register("setShort", simpleTypeConverter);
        this.register("setInt", simpleTypeConverter);
        this.register("setLong", simpleTypeConverter);
        this.register("setFloat", simpleTypeConverter);
        this.register("setDouble", simpleTypeConverter);
        this.register("setBigDecimal", simpleTypeConverter);
        this.register("setString", simpleTypeConverter);
        this.register("setDate", simpleTypeConverter);
        this.register("setTime", simpleTypeConverter);
        this.register("setTimestamp", simpleTypeConverter);
        this.register("setURL", simpleTypeConverter);
        this.register("setRef", simpleTypeConverter);
        this.register("setNString", simpleTypeConverter);
    }

    public String convert(String methodName, Object[] args) {
        Converter converter = this.converterMap.get(methodName);
        if (converter == null) {
            return "";
        }
        return converter.convert(args);
    }

    public String convert(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Byte) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Boolean) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Short) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Integer) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Long) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Float) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Double) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof BigDecimal) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof String) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Date) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Time) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Timestamp) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof URL) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof Ref) {
            return this.simpleTypeConverter.convert(value);
        }
        if (value instanceof InputStream) {
            return this.classNameConverter.convert(value);
        }
        if (value instanceof Reader) {
            return this.classNameConverter.convert(value);
        }
        if (value instanceof Array) {
            return this.classNameConverter.convert(value);
        }
        if (value instanceof SQLXML) {
            return this.classNameConverter.convert(value);
        }
        if (value instanceof byte[]) {
            return this.hexBytesConverter.convert(value);
        }
        return this.objectConverter.convert(value);
    }
}

