/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.InterceptorRegistry;
import com.navercorp.pinpoint.profiler.instrument.ASMInterceptorHolder;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorType;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.util.Comparator;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMMethodVariables {
    private static final Type BYTE_TYPE = Type.getObjectType((String)"java/lang/Byte");
    private static final Type BOOLEAN_TYPE = Type.getObjectType((String)"java/lang/Boolean");
    private static final Type SHORT_TYPE = Type.getObjectType((String)"java/lang/Short");
    private static final Type CHARACTER_TYPE = Type.getObjectType((String)"java/lang/Character");
    private static final Type INTEGER_TYPE = Type.getObjectType((String)"java/lang/Integer");
    private static final Type FLOAT_TYPE = Type.getObjectType((String)"java/lang/Float");
    private static final Type LONG_TYPE = Type.getObjectType((String)"java/lang/Long");
    private static final Type DOUBLE_TYPE = Type.getObjectType((String)"java/lang/Double");
    private static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");
    private static final Comparator<LocalVariableNode> INDEX_COMPARATOR = new Comparator<LocalVariableNode>(){

        @Override
        public int compare(LocalVariableNode o1, LocalVariableNode o2) {
            return Integer.compare(o1.index, o2.index);
        }
    };
    private final LabelNode interceptorVariableStartLabelNode = new LabelNode();
    private final LabelNode interceptorVariableEndLabelNode = new LabelNode();
    private final String declaringClassInternalName;
    private final MethodNode methodNode;
    private final Type[] argumentTypes;
    private final Type returnType;
    private boolean initializedInterceptorLocalVariables = false;
    private AbstractInsnNode enterInsnNode;
    private AbstractInsnNode exitInsnNode;
    private int nextLocals;
    private int interceptorVarIndex;
    private int arg0VarIndex;
    private int arg1VarIndex;
    private int arg2VarIndex;
    private int arg3VarIndex;
    private int arg4VarIndex;
    private int argsVarIndex;
    private int classNameVarIndex;
    private int methodNameVarIndex;
    private int parameterDescriptionVarIndex;
    private int apiIdVarIndex;
    private int resultVarIndex;
    private int throwableVarIndex;

    public ASMMethodVariables(String declaringClassInternalName, MethodNode methodNode) {
        this.declaringClassInternalName = declaringClassInternalName;
        this.methodNode = methodNode;
        this.nextLocals = methodNode.maxLocals;
        this.argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        this.returnType = Type.getReturnType((String)methodNode.desc);
    }

    public AbstractInsnNode getEnterInsnNode() {
        return this.enterInsnNode;
    }

    public AbstractInsnNode getExitInsnNode() {
        return this.exitInsnNode;
    }

    public String[] getParameterTypes() {
        String[] parameterTypes = new String[this.argumentTypes.length];
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            parameterTypes[i] = this.argumentTypes[i].getClassName();
        }
        return parameterTypes;
    }

    public String[] getParameterNames() {
        if (this.argumentTypes.length == 0) {
            return new String[0];
        }
        List localVariableNodes = this.methodNode.localVariables;
        int localVariableStartIndex = 1;
        if (this.isStatic()) {
            localVariableStartIndex = 0;
        }
        if (localVariableNodes == null || localVariableNodes.size() <= localVariableStartIndex || this.argumentTypes.length + localVariableStartIndex > localVariableNodes.size()) {
            String[] names = new String[this.argumentTypes.length];
            for (int i = 0; i < this.argumentTypes.length; ++i) {
                String className = this.argumentTypes[i].getClassName();
                if (className != null) {
                    int findIndex = className.lastIndexOf(46);
                    if (findIndex == -1) {
                        names[i] = className;
                        continue;
                    }
                    names[i] = className.substring(findIndex + 1);
                    continue;
                }
                names[i] = this.argumentTypes[i].getDescriptor();
            }
            return names;
        }
        localVariableNodes.sort(INDEX_COMPARATOR);
        String[] names = new String[this.argumentTypes.length];
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            String name = ((LocalVariableNode)localVariableNodes.get((int)localVariableStartIndex++)).name;
            names[i] = name != null ? name : "";
        }
        return names;
    }

    public String getReturnType() {
        return this.returnType.getClassName();
    }

    public boolean hasInterceptor() {
        List localVariableNodes = this.methodNode.localVariables;
        if (localVariableNodes == null) {
            return false;
        }
        for (LocalVariableNode node : localVariableNodes) {
            if (!node.name.equals("_$PINPOINT$_interceptor")) continue;
            return true;
        }
        return false;
    }

    public void initLocalVariables(InsnList instructions) {
        LabelNode variableStartLabelNode = new LabelNode();
        LabelNode variableEndLabelNode = new LabelNode();
        if (instructions.getFirst() != null) {
            instructions.insertBefore(instructions.getFirst(), (AbstractInsnNode)variableStartLabelNode);
        } else {
            instructions.insert((AbstractInsnNode)variableStartLabelNode);
        }
        instructions.insert(instructions.getLast(), (AbstractInsnNode)variableEndLabelNode);
        if (!this.isStatic()) {
            this.addLocalVariable("this", Type.getObjectType((String)this.declaringClassInternalName).getDescriptor(), variableStartLabelNode, variableEndLabelNode);
        }
        for (Type type : this.argumentTypes) {
            this.addLocalVariable(JavaAssistUtils.javaClassNameToVariableName(type.getClassName()), type.getDescriptor(), variableStartLabelNode, variableEndLabelNode);
        }
    }

    public boolean initInterceptorLocalVariables(InsnList instructions, int interceptorId, InterceptorDefinition interceptorDefinition, int apiId) {
        if (this.initializedInterceptorLocalVariables) {
            return false;
        }
        this.initializedInterceptorLocalVariables = true;
        this.enterInsnNode = this.isConstructor() ? this.findInitConstructorInstruction() : this.methodNode.instructions.getFirst();
        if (this.enterInsnNode == null) {
            throw new IllegalStateException("not found enter code. " + this.declaringClassInternalName + "/" + this.methodNode.name + this.methodNode.desc);
        }
        this.exitInsnNode = this.methodNode.instructions.getLast();
        this.methodNode.instructions.insertBefore(this.enterInsnNode, (AbstractInsnNode)this.interceptorVariableStartLabelNode);
        this.methodNode.instructions.insert(this.exitInsnNode, (AbstractInsnNode)this.interceptorVariableEndLabelNode);
        this.initInterceptorVar(instructions, interceptorId);
        InterceptorType interceptorType = interceptorDefinition.getInterceptorType();
        if (interceptorType == InterceptorType.ARRAY_ARGS) {
            this.initArgsVar(instructions);
        } else if (interceptorType == InterceptorType.STATIC) {
            this.initClassNameVar(instructions);
            this.initMethodNameVar(instructions);
            this.initParameterDescriptionVar(instructions);
            this.initArgsVar(instructions);
        } else if (interceptorType == InterceptorType.API_ID_AWARE) {
            this.initApiIdVar(apiId, instructions);
            this.initArgsVar(instructions);
        } else if (interceptorType == InterceptorType.BASIC) {
            int interceptorMethodParameterCount = this.getInterceptorParameterCount(interceptorDefinition);
            int methodParameterCount = this.argumentTypes.length;
            int argumentCount = Math.min(methodParameterCount, interceptorMethodParameterCount);
            for (int i = 1; i <= argumentCount; ++i) {
                if (i == 1) {
                    this.initArg0Var(instructions);
                    continue;
                }
                if (i == 2) {
                    this.initArg1Var(instructions);
                    continue;
                }
                if (i == 3) {
                    this.initArg2Var(instructions);
                    continue;
                }
                if (i == 4) {
                    this.initArg3Var(instructions);
                    continue;
                }
                if (i != 5) continue;
                this.initArg4Var(instructions);
            }
        }
        return true;
    }

    AbstractInsnNode findInitConstructorInstruction() {
        int nested = 0;
        for (AbstractInsnNode insnNode = this.methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            MethodInsnNode methodInsnNode;
            if (insnNode instanceof TypeInsnNode) {
                if (insnNode.getOpcode() != 187) continue;
                ++nested;
                continue;
            }
            if (!(insnNode instanceof MethodInsnNode) || (methodInsnNode = (MethodInsnNode)insnNode).getOpcode() != 183 || !methodInsnNode.name.equals("<init>") || --nested >= 0) continue;
            return insnNode.getNext();
        }
        return null;
    }

    private void initInterceptorVar(InsnList instructions, int interceptorId) {
        this.assertInitializedInterceptorLocalVariables();
        this.interceptorVarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_interceptor", "Lcom/navercorp/pinpoint/bootstrap/interceptor/Interceptor;");
        if (InterceptorRegistry.contains((int)interceptorId) || Boolean.FALSE == InterceptorRegistry.isInterceptorHolderEnable()) {
            this.push(instructions, interceptorId);
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(InterceptorRegistry.class), "getInterceptor", "(I)" + Type.getDescriptor(Interceptor.class), false));
        } else {
            String className = ASMInterceptorHolder.getInterceptorHolderClassName(interceptorId);
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, JavaAssistUtils.javaNameToJvmName(className), "get", "()" + Type.getDescriptor(Interceptor.class), false));
        }
        this.storeVar(instructions, this.interceptorVarIndex);
        this.resultVarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_result", "Ljava/lang/Object;");
        this.loadNull(instructions);
        this.storeVar(instructions, this.resultVarIndex);
        this.throwableVarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_throwable", "Ljava/lang/Throwable;");
        this.loadNull(instructions);
        this.storeVar(instructions, this.throwableVarIndex);
    }

    private void initArgsVar(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.argsVarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_args", "[Ljava/lang/Object;");
        this.loadArgsVar(instructions);
        this.storeVar(instructions, this.argsVarIndex);
    }

    private void initClassNameVar(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.classNameVarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_className", "Ljava/lang/String;");
        this.push(instructions, JavaAssistUtils.jvmNameToJavaName(this.declaringClassInternalName));
        this.storeVar(instructions, this.classNameVarIndex);
    }

    private void initMethodNameVar(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.methodNameVarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_methodName", "Ljava/lang/String;");
        this.push(instructions, this.methodNode.name);
        this.storeVar(instructions, this.methodNameVarIndex);
    }

    private void initParameterDescriptionVar(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.parameterDescriptionVarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_parameterDescription", "Ljava/lang/String;");
        this.push(instructions, this.methodNode.desc);
        this.storeVar(instructions, this.parameterDescriptionVarIndex);
    }

    private void initApiIdVar(int apiId, InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.apiIdVarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_apiId", "I");
        this.push(instructions, apiId);
        this.storeInt(instructions, this.apiIdVarIndex);
    }

    private void initArg0Var(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.arg0VarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_arg0", "Ljava/lang/String;");
        this.loadArg(instructions, this.argumentTypes, 0);
        this.box(instructions, this.argumentTypes[0]);
        this.storeVar(instructions, this.arg0VarIndex);
    }

    private void initArg1Var(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.arg1VarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_arg1", "Ljava/lang/String;");
        this.loadArg(instructions, this.argumentTypes, 1);
        this.box(instructions, this.argumentTypes[1]);
        this.storeVar(instructions, this.arg1VarIndex);
    }

    private void initArg2Var(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.arg2VarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_arg2", "Ljava/lang/String;");
        this.loadArg(instructions, this.argumentTypes, 2);
        this.box(instructions, this.argumentTypes[2]);
        this.storeVar(instructions, this.arg2VarIndex);
    }

    private void initArg3Var(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.arg3VarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_arg3", "Ljava/lang/String;");
        this.loadArg(instructions, this.argumentTypes, 3);
        this.box(instructions, this.argumentTypes[3]);
        this.storeVar(instructions, this.arg3VarIndex);
    }

    private void initArg4Var(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.arg4VarIndex = this.addInterceptorLocalVariable("_$PINPOINT$_arg4", "Ljava/lang/String;");
        this.loadArg(instructions, this.argumentTypes, 4);
        this.box(instructions, this.argumentTypes[4]);
        this.storeVar(instructions, this.arg4VarIndex);
    }

    int getInterceptorParameterCount(InterceptorDefinition interceptorDefinition) {
        if (interceptorDefinition.getBeforeMethod() != null) {
            return interceptorDefinition.getBeforeMethod().getParameterCount() - 1;
        }
        if (interceptorDefinition.getAfterMethod() != null) {
            return interceptorDefinition.getAfterMethod().getParameterCount() - 3;
        }
        return 0;
    }

    public void storeThrowableVar(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.storeVar(instructions, this.throwableVarIndex);
        this.loadNull(instructions);
        this.storeVar(instructions, this.resultVarIndex);
    }

    public void storeResultVar(InsnList instructions, int opcode) {
        this.assertInitializedInterceptorLocalVariables();
        if (opcode == 177) {
            this.loadNull(instructions);
        } else if (opcode == 176) {
            this.dup(instructions);
        } else {
            if (opcode == 173 || opcode == 175) {
                this.dup2(instructions);
            } else {
                this.dup(instructions);
            }
            Type type = Type.getReturnType((String)this.methodNode.desc);
            this.box(instructions, type);
        }
        this.storeVar(instructions, this.resultVarIndex);
        this.loadNull(instructions);
        this.storeVar(instructions, this.throwableVarIndex);
    }

    public void loadInterceptorLocalVariables(InsnList instructions, InterceptorDefinition interceptorDefinition, boolean after) {
        this.assertInitializedInterceptorLocalVariables();
        this.loadVar(instructions, this.interceptorVarIndex);
        instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(interceptorDefinition.getInterceptorBaseClass())));
        this.loadThis(instructions);
        InterceptorType interceptorType = interceptorDefinition.getInterceptorType();
        if (interceptorType == InterceptorType.ARRAY_ARGS) {
            this.loadVar(instructions, this.argsVarIndex);
        } else if (interceptorType == InterceptorType.STATIC) {
            this.loadVar(instructions, this.classNameVarIndex);
            this.loadVar(instructions, this.methodNameVarIndex);
            this.loadVar(instructions, this.parameterDescriptionVarIndex);
            this.loadVar(instructions, this.argsVarIndex);
        } else if (interceptorType == InterceptorType.API_ID_AWARE) {
            this.loadInt(instructions, this.apiIdVarIndex);
            this.loadVar(instructions, this.argsVarIndex);
        } else if (interceptorType == InterceptorType.BASIC) {
            int i;
            int interceptorMethodParameterCount = this.getInterceptorParameterCount(interceptorDefinition);
            int argumentCount = Math.min(this.argumentTypes.length, interceptorMethodParameterCount);
            for (i = 1; i <= argumentCount; ++i) {
                if (i == 1) {
                    this.loadVar(instructions, this.arg0VarIndex);
                    continue;
                }
                if (i == 2) {
                    this.loadVar(instructions, this.arg1VarIndex);
                    continue;
                }
                if (i == 3) {
                    this.loadVar(instructions, this.arg2VarIndex);
                    continue;
                }
                if (i == 4) {
                    this.loadVar(instructions, this.arg3VarIndex);
                    continue;
                }
                if (i == 5) {
                    this.loadVar(instructions, this.arg4VarIndex);
                    continue;
                }
                this.loadNull(instructions);
            }
            while (i <= interceptorMethodParameterCount) {
                this.loadNull(instructions);
                ++i;
            }
        }
        if (after) {
            this.loadVar(instructions, this.resultVarIndex);
            this.loadVar(instructions, this.throwableVarIndex);
        }
    }

    public void loadInterceptorThrowVar(InsnList instructions) {
        this.assertInitializedInterceptorLocalVariables();
        this.loadVar(instructions, this.throwableVarIndex);
        instructions.add((AbstractInsnNode)new InsnNode(191));
    }

    void loadThis(InsnList instructions) {
        if (this.isConstructor()) {
            this.loadVar(instructions, 0);
        } else if (this.isStatic()) {
            this.loadNull(instructions);
        } else {
            this.loadVar(instructions, 0);
        }
    }

    void storeVar(InsnList instructions, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(58, index));
    }

    void storeInt(InsnList instructions, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(54, index));
    }

    void loadNull(InsnList instructions) {
        instructions.add((AbstractInsnNode)new InsnNode(1));
    }

    void loadVar(InsnList instructions, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(25, index));
    }

    void loadInt(InsnList instructions, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(21, index));
    }

    boolean isReturnCode(int opcode) {
        return opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176 || opcode == 177;
    }

    Type getBoxedType(Type type) {
        switch (type.getSort()) {
            case 3: {
                return BYTE_TYPE;
            }
            case 1: {
                return BOOLEAN_TYPE;
            }
            case 4: {
                return SHORT_TYPE;
            }
            case 2: {
                return CHARACTER_TYPE;
            }
            case 5: {
                return INTEGER_TYPE;
            }
            case 6: {
                return FLOAT_TYPE;
            }
            case 7: {
                return LONG_TYPE;
            }
            case 8: {
                return DOUBLE_TYPE;
            }
        }
        return type;
    }

    void push(InsnList insnList, int value) {
        if (value >= -1 && value <= 5) {
            insnList.add((AbstractInsnNode)new InsnNode(3 + value));
        } else if (value >= -128 && value <= 127) {
            insnList.add((AbstractInsnNode)new IntInsnNode(16, value));
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            insnList.add((AbstractInsnNode)new IntInsnNode(17, value));
        } else {
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    void push(InsnList insnList, String value) {
        if (value == null) {
            insnList.add((AbstractInsnNode)new InsnNode(1));
        } else {
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    void newArray(InsnList insnList, Type type) {
        insnList.add((AbstractInsnNode)new TypeInsnNode(189, type.getInternalName()));
    }

    void dup(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(89));
    }

    void dup2(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(92));
    }

    void dupX1(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(90));
    }

    void dupX2(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(91));
    }

    void pop(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(87));
    }

    void swap(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(95));
    }

    void loadArgsVar(InsnList instructions) {
        if (this.argumentTypes.length == 0) {
            this.loadNull(instructions);
            return;
        }
        this.push(instructions, this.argumentTypes.length);
        this.newArray(instructions, OBJECT_TYPE);
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            Type type = this.argumentTypes[i];
            this.dup(instructions);
            this.push(instructions, i);
            this.loadArg(instructions, this.argumentTypes, i);
            this.box(instructions, type);
            this.arrayStore(instructions, OBJECT_TYPE);
        }
    }

    void loadArgs(InsnList instructions) {
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.loadArg(instructions, this.argumentTypes, i);
        }
    }

    void loadArg(InsnList instructions, Type[] argumentTypes, int i) {
        int index = this.getArgIndex(argumentTypes, i);
        Type type = argumentTypes[i];
        instructions.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), index));
    }

    int getArgIndex(Type[] argumentTypes, int arg) {
        int index = this.isStatic() ? 0 : 1;
        for (int i = 0; i < arg; ++i) {
            index += argumentTypes[i].getSize();
        }
        return index;
    }

    void box(InsnList instructions, Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
        } else {
            Type boxed = this.getBoxedType(type);
            this.newInstance(instructions, boxed);
            if (type.getSize() == 2) {
                this.dupX2(instructions);
                this.dupX2(instructions);
                this.pop(instructions);
            } else {
                this.dupX1(instructions);
                this.swap(instructions);
            }
            this.invokeConstructor(instructions, boxed, new Method("<init>", Type.VOID_TYPE, new Type[]{type}));
        }
    }

    void arrayStore(InsnList instructions, Type type) {
        instructions.add((AbstractInsnNode)new InsnNode(type.getOpcode(79)));
    }

    void newInstance(InsnList instructions, Type type) {
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, type.getInternalName()));
    }

    void invokeConstructor(InsnList instructions, Type type, Method method) {
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, owner, method.getName(), method.getDescriptor(), false));
    }

    int addInterceptorLocalVariable(String name, String desc) {
        return this.addLocalVariable(name, desc, this.interceptorVariableStartLabelNode, this.interceptorVariableEndLabelNode);
    }

    int addLocalVariable(String name, String desc, LabelNode start, LabelNode end) {
        int index = this.nextLocals++;
        LocalVariableNode node = new LocalVariableNode(name, desc, null, start, end, index);
        this.methodNode.localVariables.add(node);
        return index;
    }

    public void returnValue(InsnList instructions) {
        instructions.add((AbstractInsnNode)new InsnNode(this.returnType.getOpcode(172)));
    }

    private boolean isStatic() {
        return (this.methodNode.access & 8) != 0;
    }

    private boolean isConstructor() {
        return this.methodNode.name != null && this.methodNode.name.equals("<init>");
    }

    private void assertInitializedInterceptorLocalVariables() {
        if (!this.initializedInterceptorLocalVariables) {
            throw new IllegalStateException("The interceptor local variables must be initialized.");
        }
    }

    List<LocalVariableNode> getLocalVariables() {
        return this.methodNode.localVariables;
    }
}

