/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.ClassInputStreamProvider;
import com.navercorp.pinpoint.common.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public final class ASMClassWriter
extends ClassWriter {
    private static final String OBJECT_CLASS_INTERNAL_NAME = "java/lang/Object";
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ClassInputStreamProvider pluginInputStreamProvider;
    private final ClassLoader classLoader;

    public ASMClassWriter(ClassInputStreamProvider pluginInputStreamProvider, int flags, ClassLoader classLoader) {
        super(flags);
        this.pluginInputStreamProvider = pluginInputStreamProvider;
        this.classLoader = classLoader;
    }

    protected String getCommonSuperClass(String classInternalName1, String classInternalName2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting common super class. classInternalName1={}, classInternalName2={}", (Object)classInternalName1, (Object)classInternalName2);
        }
        String classInternalName = this.get(classInternalName1, classInternalName2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Common super class is '{}'. classInternalName1={}, classInternalName2={}", (Object)classInternalName, (Object)classInternalName1, (Object)classInternalName2);
        }
        return classInternalName;
    }

    private String get(String classInternalName1, String classInternalName2) {
        if (classInternalName1 == null || classInternalName1.equals(OBJECT_CLASS_INTERNAL_NAME) || classInternalName2 == null || classInternalName2.equals(OBJECT_CLASS_INTERNAL_NAME)) {
            return OBJECT_CLASS_INTERNAL_NAME;
        }
        if (classInternalName1.equals(classInternalName2)) {
            return classInternalName1;
        }
        ClassReader classReader1 = this.getClassReader(classInternalName1);
        if (classReader1 == null) {
            this.logger.warn("Skip getCommonSuperClass(). not found class {}", (Object)classInternalName1);
            return OBJECT_CLASS_INTERNAL_NAME;
        }
        ClassReader classReader2 = this.getClassReader(classInternalName2);
        if (classReader2 == null) {
            this.logger.warn("Skip getCommonSuperClass(). not found class {}", (Object)classInternalName2);
            return OBJECT_CLASS_INTERNAL_NAME;
        }
        if (this.isInterface(classReader1)) {
            return this.getCommonInterface(classReader1, classReader2);
        }
        if (this.isInterface(classReader2)) {
            return this.getCommonInterface(classReader2, classReader1);
        }
        return this.getCommonClass(classReader1, classReader2);
    }

    private boolean isInterface(ClassReader classReader) {
        return (classReader.getAccess() & 0x200) != 0;
    }

    private String getCommonInterface(ClassReader classReader1, ClassReader classReader2) {
        HashSet<String> interfaceHierarchy = new HashSet<String>();
        this.traversalInterfaceHierarchy(interfaceHierarchy, classReader1);
        if (this.isInterface(classReader2) && interfaceHierarchy.contains(classReader2.getClassName())) {
            return classReader2.getClassName();
        }
        String interfaceInternalName = this.getImplementedInterface(interfaceHierarchy, classReader2);
        if (interfaceInternalName != null) {
            return interfaceInternalName;
        }
        return OBJECT_CLASS_INTERNAL_NAME;
    }

    private void traversalInterfaceHierarchy(Set<String> interfaceHierarchy, ClassReader classReader) {
        if (classReader != null && interfaceHierarchy.add(classReader.getClassName())) {
            for (String interfaceInternalName : classReader.getInterfaces()) {
                this.traversalInterfaceHierarchy(interfaceHierarchy, this.getClassReader(interfaceInternalName));
            }
        }
    }

    private String getImplementedInterface(Set<String> interfaceHierarchy, ClassReader classReader) {
        ClassReader cr = classReader;
        while (cr != null) {
            String[] interfaceInternalNames;
            for (String name : interfaceInternalNames = cr.getInterfaces()) {
                if (name == null || !interfaceHierarchy.contains(name)) continue;
                return name;
            }
            for (String name : interfaceInternalNames) {
                String interfaceInternalName = this.getImplementedInterface(interfaceHierarchy, this.getClassReader(name));
                if (interfaceInternalName == null) continue;
                return interfaceInternalName;
            }
            String superClassInternalName = cr.getSuperName();
            if (superClassInternalName == null || superClassInternalName.equals(OBJECT_CLASS_INTERNAL_NAME)) break;
            cr = this.getClassReader(superClassInternalName);
        }
        return null;
    }

    private String getCommonClass(ClassReader classReader1, ClassReader classReader2) {
        HashSet<String> classHierarchy = new HashSet<String>();
        classHierarchy.add(classReader1.getClassName());
        classHierarchy.add(classReader2.getClassName());
        String superClassInternalName1 = classReader1.getSuperName();
        if (!classHierarchy.add(superClassInternalName1)) {
            return superClassInternalName1;
        }
        String superClassInternalName2 = classReader2.getSuperName();
        if (!classHierarchy.add(superClassInternalName2)) {
            return superClassInternalName2;
        }
        while (superClassInternalName1 != null || superClassInternalName2 != null) {
            if (superClassInternalName1 != null && (superClassInternalName1 = this.getSuperClassInternalName(superClassInternalName1)) != null && !classHierarchy.add(superClassInternalName1)) {
                return superClassInternalName1;
            }
            if (superClassInternalName2 == null || (superClassInternalName2 = this.getSuperClassInternalName(superClassInternalName2)) == null || classHierarchy.add(superClassInternalName2)) continue;
            return superClassInternalName2;
        }
        return OBJECT_CLASS_INTERNAL_NAME;
    }

    private String getSuperClassInternalName(String classInternalName) {
        ClassReader classReader = this.getClassReader(classInternalName);
        if (classReader == null) {
            return null;
        }
        return classReader.getSuperName();
    }

    private ClassReader getClassReader(String classInternalName) {
        if (classInternalName == null) {
            return null;
        }
        String classFileName = classInternalName.concat(".class");
        InputStream in = this.pluginInputStreamProvider.getResourceAsStream(this.classLoader, classFileName);
        if (in == null) {
            return null;
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            return new ClassReader(bytes);
        }
        catch (IOException e) {
            return null;
        }
    }
}

