/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.common.profiler.message.DataSender;
import com.navercorp.pinpoint.profiler.context.SpanChunkFactory;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.storage.BufferedStorage;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import java.util.Objects;

public class BufferedStorageFactory
implements StorageFactory {
    private final DataSender<SpanType> dataSender;
    private final int ioBufferingBufferSize;

    public BufferedStorageFactory(int ioBufferingBufferSize, DataSender<SpanType> dataSender) {
        this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
        this.ioBufferingBufferSize = ioBufferingBufferSize;
    }

    @Override
    public Storage createStorage(SpanChunkFactory spanChunkFactory) {
        BufferedStorage storage = new BufferedStorage(spanChunkFactory, this.dataSender, this.ioBufferingBufferSize);
        return storage;
    }

    public String toString() {
        return "BufferedStorageFactory{dataSender=" + this.dataSender + ", ioBufferingBufferSize=" + this.ioBufferingBufferSize + '}';
    }
}

