/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.common.profiler.message.DataSender;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanChunkFactory;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.util.queue.ArrayBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferedStorage
implements Storage {
    private static final Logger logger = LogManager.getLogger(BufferedStorage.class);
    private static final boolean isDebug = logger.isDebugEnabled();
    private static final int DEFAULT_BUFFER_SIZE = 20;
    private final SpanChunkFactory spanChunkFactory;
    private final DataSender<SpanType> dataSender;
    private final ArrayBuffer<SpanEvent> buffer;

    public BufferedStorage(SpanChunkFactory spanChunkFactory, DataSender<SpanType> dataSender, int bufferSize) {
        this.spanChunkFactory = Objects.requireNonNull(spanChunkFactory, "spanChunkFactory");
        this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
        this.buffer = new ArrayBuffer(bufferSize);
    }

    @Override
    public void store(SpanEvent spanEvent) {
        this.buffer.put(spanEvent);
        if (this.buffer.isOverflow()) {
            List<SpanEvent> flushData = this.buffer.drain();
            this.sendSpanChunk(flushData);
        }
    }

    @Override
    public void store(Span span) {
        boolean success;
        List<SpanEvent> spanEventList = this.buffer.drain();
        span.setSpanEventList(spanEventList);
        span.finish();
        if (isDebug) {
            logger.debug("Flush {}", (Object)span);
        }
        if (!(success = this.dataSender.send((Object)span))) {
            logger.debug("send fail");
        }
    }

    @Override
    public void flush() {
        List<SpanEvent> spanEventList = this.buffer.drain();
        if (CollectionUtils.hasLength(spanEventList)) {
            this.sendSpanChunk(spanEventList);
        }
    }

    private void sendSpanChunk(List<SpanEvent> spanEventList) {
        boolean success;
        SpanChunk spanChunk = this.spanChunkFactory.newSpanChunk(spanEventList);
        if (isDebug) {
            logger.debug("Flush {}", (Object)spanChunk);
        }
        if (!(success = this.dataSender.send((Object)spanChunk))) {
            logger.debug("send fail");
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "BufferedStorage{buffer=" + this.buffer + ", dataSender=" + this.dataSender + '}';
    }
}

