/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module.config;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.TransportModule;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import com.navercorp.pinpoint.profiler.context.config.DefaultContextConfig;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentName;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.ApplicationName;
import com.navercorp.pinpoint.profiler.context.module.BootstrapJarPaths;
import com.navercorp.pinpoint.profiler.context.module.ConfiguredApplicationType;
import com.navercorp.pinpoint.profiler.context.module.Container;
import com.navercorp.pinpoint.profiler.context.module.PluginJarPaths;
import com.navercorp.pinpoint.profiler.context.module.PluginJars;
import com.navercorp.pinpoint.profiler.context.module.config.ConfigurationLoader;
import com.navercorp.pinpoint.profiler.context.module.config.DeadlockMonitorEnable;
import com.navercorp.pinpoint.profiler.context.module.config.DeadlockMonitorInterval;
import com.navercorp.pinpoint.profiler.context.module.config.TraceAgentActiveThread;
import com.navercorp.pinpoint.profiler.context.monitor.config.DefaultMonitorConfig;
import com.navercorp.pinpoint.profiler.context.monitor.config.MonitorConfig;
import com.navercorp.pinpoint.profiler.context.provider.AgentStartTimeProvider;
import com.navercorp.pinpoint.profiler.context.provider.ConfiguredApplicationTypeProvider;
import com.navercorp.pinpoint.profiler.context.provider.InterceptorRegistryBinderProvider;
import com.navercorp.pinpoint.profiler.context.provider.ShutdownHookRegisterProvider;
import com.navercorp.pinpoint.profiler.context.provider.TraceDataFormatVersionProvider;
import com.navercorp.pinpoint.profiler.context.provider.plugin.PluginJarsProvider;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapCore;
import com.navercorp.pinpoint.profiler.instrument.config.DefaultInstrumentConfig;
import com.navercorp.pinpoint.profiler.instrument.config.DefaultInstrumentMatcherCacheConfig;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentConfig;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentMatcherCacheConfig;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import com.navercorp.pinpoint.profiler.plugin.config.DefaultPluginLoadingConfig;
import com.navercorp.pinpoint.profiler.plugin.config.PluginLoadingConfig;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigModule
extends AbstractModule {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final AgentOption agentOption;

    public ConfigModule(AgentOption agentOption) {
        this.agentOption = Objects.requireNonNull(agentOption, "profilerConfig");
        Objects.requireNonNull(agentOption.getProfilerConfig(), "profilerConfig");
    }

    protected void configure() {
        this.logger.info("configure {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        this.binder().requireExplicitBindings();
        this.binder().requireAtInjectOnConstructors();
        this.binder().disableCircularProxies();
        ProfilerConfig profilerConfig = this.agentOption.getProfilerConfig();
        this.bind(ProfilerConfig.class).toInstance((Object)profilerConfig);
        Properties properties = profilerConfig.getProperties();
        ConfigurationLoader configurationLoader = new ConfigurationLoader(properties);
        DefaultContextConfig contextConfig = new DefaultContextConfig();
        configurationLoader.load(contextConfig);
        this.logger.info("{}", (Object)contextConfig);
        this.bind(ContextConfig.class).toInstance((Object)contextConfig);
        this.bindConstants(contextConfig);
        DefaultPluginLoadingConfig pluginLoadingConfig = new DefaultPluginLoadingConfig();
        configurationLoader.load(pluginLoadingConfig);
        this.logger.info("{}", (Object)pluginLoadingConfig);
        this.bind(PluginLoadingConfig.class).toInstance((Object)pluginLoadingConfig);
        DefaultInstrumentConfig instrumentConfig = new DefaultInstrumentConfig();
        configurationLoader.load(instrumentConfig);
        this.logger.info("{}", (Object)instrumentConfig);
        this.bind(InstrumentConfig.class).toInstance((Object)instrumentConfig);
        DefaultInstrumentMatcherCacheConfig instrumentMatcherCacheConfig = new DefaultInstrumentMatcherCacheConfig();
        configurationLoader.load(instrumentMatcherCacheConfig);
        this.logger.info("{}", (Object)instrumentMatcherCacheConfig);
        this.bind(InstrumentMatcherCacheConfig.class).toInstance((Object)instrumentMatcherCacheConfig);
        DefaultMonitorConfig monitorConfig = new DefaultMonitorConfig();
        configurationLoader.load(monitorConfig);
        this.logger.info("{}", (Object)monitorConfig);
        this.bind(MonitorConfig.class).toInstance((Object)monitorConfig);
        this.bind(TransportModule.class).toInstance((Object)profilerConfig.getTransportModule());
        this.bind(Instrumentation.class).toInstance((Object)this.agentOption.getInstrumentation());
        this.bind(InterceptorRegistryBinder.class).toProvider(InterceptorRegistryBinderProvider.class).in(Scopes.SINGLETON);
        TypeLiteral<List<String>> pluginJarFile = new TypeLiteral<List<String>>(){};
        this.bind((TypeLiteral)pluginJarFile).annotatedWith(PluginJarPaths.class).toInstance((Object)this.agentOption.getPluginJars());
        TypeLiteral<List<PluginJar>> pluginJars = new TypeLiteral<List<PluginJar>>(){};
        this.bind((TypeLiteral)pluginJars).annotatedWith(PluginJars.class).toProvider(PluginJarsProvider.class).in(Scopes.SINGLETON);
        this.bindBootstrapCoreInformation();
        this.bindAgentInformation(this.agentOption.getAgentId(), this.agentOption.getAgentName(), this.agentOption.getApplicationName(), this.agentOption.isContainer());
        this.bindShutdownHook(contextConfig);
    }

    private void bindBootstrapCoreInformation() {
        List bootstrapJarPaths = this.agentOption.getBootstrapJarPaths();
        TypeLiteral<List<String>> bootstrapJarFIle = new TypeLiteral<List<String>>(){};
        this.bind((TypeLiteral)bootstrapJarFIle).annotatedWith(BootstrapJarPaths.class).toInstance((Object)bootstrapJarPaths);
        BootstrapCore bootstrapCore = new BootstrapCore(bootstrapJarPaths);
        this.bind(BootstrapCore.class).toInstance((Object)bootstrapCore);
    }

    private void bindConstants(ContextConfig contextConfig) {
        this.bind(TraceDataFormatVersion.class).toProvider(TraceDataFormatVersionProvider.class).in(Scopes.SINGLETON);
        this.bindConstant().annotatedWith(TraceAgentActiveThread.class).to(contextConfig.isTraceAgentActiveThread());
        this.bindConstant().annotatedWith(DeadlockMonitorEnable.class).to(contextConfig.isDeadlockMonitorEnable());
        this.bindConstant().annotatedWith(DeadlockMonitorInterval.class).to(contextConfig.getDeadlockMonitorInterval());
    }

    private void bindAgentInformation(String agentId, String agentName, String applicationName, boolean isContainer) {
        this.bind(String.class).annotatedWith(AgentId.class).toInstance((Object)agentId);
        this.bind(String.class).annotatedWith(AgentName.class).toInstance((Object)agentName);
        this.bind(String.class).annotatedWith(ApplicationName.class).toInstance((Object)applicationName);
        this.bind(Boolean.class).annotatedWith(Container.class).toInstance((Object)isContainer);
        this.bind(Long.class).annotatedWith(AgentStartTime.class).toProvider(AgentStartTimeProvider.class).in(Scopes.SINGLETON);
        this.bind(ServiceType.class).annotatedWith(ConfiguredApplicationType.class).toProvider(ConfiguredApplicationTypeProvider.class).in(Scopes.SINGLETON);
    }

    private void bindShutdownHook(ContextConfig contextConfig) {
        ShutdownHookRegisterProvider instance = new ShutdownHookRegisterProvider(contextConfig);
        this.bind(ShutdownHookRegisterProvider.class).toInstance((Object)instance);
    }
}

