/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.common.trace.UriStatHistogramBucket;
import com.navercorp.pinpoint.grpc.trace.PAgentUriStat;
import com.navercorp.pinpoint.grpc.trace.PEachUriStat;
import com.navercorp.pinpoint.grpc.trace.PUriHistogram;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.AgentUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.EachUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.URIKey;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatHistogram;
import java.util.Map;
import org.mapstruct.AfterMapping;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS, nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, uses={})
public interface UriStatMapper {
    public static final PUriHistogram EMPTY_DETAILED_DATA_INSTANCE = PUriHistogram.getDefaultInstance();
    public static final UriStatHistogramBucket.Layout layout = UriStatHistogramBucket.getLayout();

    @Mappings(value={@Mapping(source=".", target="bucketVersion", qualifiedByName={"currentBucketVersion"}), @Mapping(source="allUriStatData", target="eachUriStat")})
    public PAgentUriStat map(AgentUriStatData var1);

    @Mappings(value={@Mapping(source="value.uri", target="uri"), @Mapping(source="value.totalHistogram", target="totalHistogram", qualifiedByName={"checkEmptyThenMap"}), @Mapping(source="value.failedHistogram", target="failedHistogram", qualifiedByName={"checkEmptyThenMap"}), @Mapping(source="key.timestamp", target="timestamp")})
    public PEachUriStat map(Map.Entry<URIKey, EachUriStatData> var1);

    @Named(value="checkEmptyThenMap")
    default public PUriHistogram checkEmptyThenMap(UriStatHistogram uriStatHistogram) {
        if (uriStatHistogram.getCount() == 0) {
            return EMPTY_DETAILED_DATA_INSTANCE;
        }
        return this.map(uriStatHistogram);
    }

    @Mappings(value={@Mapping(target="histogram", ignore=true)})
    public PUriHistogram map(UriStatHistogram var1);

    @AfterMapping
    default public void map(UriStatHistogram uriStatHistogram, @MappingTarget PUriHistogram.Builder builder) {
        int[] timestampHistograms;
        for (int eachTimestampHistogram : timestampHistograms = uriStatHistogram.getTimestampHistogram()) {
            builder.addHistogram(eachTimestampHistogram);
        }
    }

    @Named(value="currentBucketVersion")
    default public int getBucketVersion(AgentUriStatData agentUriStatData) {
        return layout.getBucketVersion();
    }
}

