/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception.storage;

import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionMetaDataFactory;
import com.navercorp.pinpoint.profiler.context.exception.storage.BufferedExceptionStorage;
import com.navercorp.pinpoint.profiler.context.exception.storage.ExceptionStorage;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import java.util.Objects;

public class ExceptionStorageFactory {
    private final EnhancedDataSender<MetaDataType, ResponseMessage> dataSender;
    private final int bufferSize;

    public ExceptionStorageFactory(EnhancedDataSender<MetaDataType, ResponseMessage> dataSender, int bufferSize) {
        this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
        this.bufferSize = bufferSize;
    }

    public ExceptionStorage createStorage(ExceptionMetaDataFactory factory) {
        return new BufferedExceptionStorage(this.bufferSize, this.dataSender, factory);
    }
}

