/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception;

import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContext;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapper;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapperFactory;
import com.navercorp.pinpoint.profiler.context.exception.sampler.ExceptionChainSampler;
import java.util.Collections;
import java.util.List;

public enum ExceptionRecordingState {
    NEW{

        @Override
        public List<ExceptionWrapper> toWrappers(ExceptionContext context, ExceptionWrapperFactory factory) {
            return factory.newExceptionWrappers(context);
        }

        @Override
        public void cleanUp(ExceptionContext context) {
            context.cleanContext();
        }
    }
    ,
    CONTINUED{

        @Override
        public List<ExceptionWrapper> toWrappers(ExceptionContext context, ExceptionWrapperFactory factory) {
            return Collections.emptyList();
        }

        @Override
        public void cleanUp(ExceptionContext context) {
        }
    }
    ,
    CLEAN{

        @Override
        public List<ExceptionWrapper> toWrappers(ExceptionContext context, ExceptionWrapperFactory factory) {
            return Collections.emptyList();
        }

        @Override
        public void cleanUp(ExceptionContext context) {
        }
    };


    public static ExceptionRecordingState stateOf(Throwable previous, Throwable current) {
        if (current == null) {
            return CLEAN;
        }
        if (ExceptionRecordingState.isChaining(previous, current)) {
            return CONTINUED;
        }
        return NEW;
    }

    private static boolean isChaining(Throwable previous, Throwable current) {
        if (previous == null && current == null) {
            return false;
        }
        for (Throwable throwable = current; throwable != null; throwable = throwable.getCause()) {
            if (throwable != previous) continue;
            return true;
        }
        return false;
    }

    public static void flush(ExceptionContext context, ExceptionChainSampler.SamplingState samplingState, ExceptionWrapperFactory factory) {
        List<ExceptionWrapper> wrappers;
        if (samplingState.isSampling() && (wrappers = factory.newExceptionWrappers(context)) != null) {
            context.store(wrappers);
        }
    }

    public boolean needsNewChainId() {
        return this == NEW;
    }

    public void pushThenUpdate(ExceptionContext context, Throwable current, long currentStartTime, ExceptionChainSampler.SamplingState samplingState, ExceptionWrapperFactory factory) {
        this.push(context, samplingState, factory);
        this.cleanUp(context);
        this.update(context, current, currentStartTime, samplingState);
    }

    private void push(ExceptionContext context, ExceptionChainSampler.SamplingState samplingState, ExceptionWrapperFactory factory) {
        List<ExceptionWrapper> wrappers;
        if (samplingState.isSampling() && (wrappers = this.toWrappers(context, factory)) != null) {
            context.store(wrappers);
        }
    }

    public void update(ExceptionContext context, Throwable current, long currentStartTime, ExceptionChainSampler.SamplingState samplingState) {
        context.update(current, currentStartTime, samplingState);
    }

    public abstract List<ExceptionWrapper> toWrappers(ExceptionContext var1, ExceptionWrapperFactory var2);

    public abstract void cleanUp(ExceptionContext var1);
}

