/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.profiler.util.ApiUtils;
import java.util.Arrays;

public class DefaultMethodDescriptor
implements MethodDescriptor {
    private static final int TYPE = 0;
    private final String className;
    private final String methodName;
    private final String[] parameterTypes;
    private final String[] parameterVariableName;
    private final String parameterDescriptor;
    private final String apiDescriptor;
    private final int lineNumber;
    private int apiId = 0;
    private String fullName;

    public DefaultMethodDescriptor(String className, String methodName, String[] parameterTypes, String[] parameterVariableName, int lineNumber) {
        this.className = className;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.parameterVariableName = parameterVariableName;
        this.parameterDescriptor = ApiUtils.mergeParameterVariableNameDescription(parameterTypes, parameterVariableName);
        this.apiDescriptor = ApiUtils.mergeApiDescriptor(className, methodName, this.parameterDescriptor);
        this.lineNumber = lineNumber;
    }

    public String getParameterDescriptor() {
        return this.parameterDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String[] getParameterVariableName() {
        return this.parameterVariableName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFullName() {
        if (this.fullName != null) {
            return this.fullName;
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.className);
        buffer.append('.');
        buffer.append(this.methodName);
        buffer.append(this.parameterDescriptor);
        if (this.lineNumber != -1) {
            buffer.append(':');
            buffer.append(this.lineNumber);
        }
        this.fullName = buffer.toString();
        return this.fullName;
    }

    public String getApiDescriptor() {
        return this.apiDescriptor;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public int getApiId() {
        return this.apiId;
    }

    public int getType() {
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{className=");
        builder.append(this.className);
        builder.append(", methodName=");
        builder.append(this.methodName);
        builder.append(", parameterTypes=");
        builder.append(Arrays.toString(this.parameterTypes));
        builder.append(", parameterVariableName=");
        builder.append(Arrays.toString(this.parameterVariableName));
        builder.append(", parameterDescriptor=");
        builder.append(this.parameterDescriptor);
        builder.append(", apiDescriptor=");
        builder.append(this.apiDescriptor);
        builder.append(", lineNumber=");
        builder.append(this.lineNumber);
        builder.append(", apiId=");
        builder.append(this.apiId);
        builder.append(", fullName=");
        builder.append(this.fullName);
        builder.append(", type=");
        builder.append(0);
        builder.append("}");
        return builder.toString();
    }
}

