/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChildTrace
implements Trace {
    private static final int ASYNC_BEGIN_STACK_ID = 1001;
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private final CallStack<SpanEvent> callStack;
    private final Storage storage;
    private final SpanRecorder spanRecorder;
    private final WrappedSpanEventRecorder wrappedSpanEventRecorder;
    private boolean closed = false;
    private DefaultTraceScopePool scopePool;
    private final TraceRoot traceRoot;
    private final LocalAsyncId localAsyncId;

    public ChildTrace(TraceRoot traceRoot, CallStack<SpanEvent> callStack, Storage storage, SpanRecorder spanRecorder, WrappedSpanEventRecorder wrappedSpanEventRecorder, LocalAsyncId localAsyncId) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.callStack = Objects.requireNonNull(callStack, "callStack");
        this.storage = Objects.requireNonNull(storage, "storage");
        this.spanRecorder = Objects.requireNonNull(spanRecorder, "spanRecorder");
        this.wrappedSpanEventRecorder = Objects.requireNonNull(wrappedSpanEventRecorder, "wrappedSpanEventRecorder");
        this.localAsyncId = Objects.requireNonNull(localAsyncId, "localAsyncId");
        this.traceBlockBegin(1001);
    }

    private TraceRoot getTraceRoot() {
        return this.traceRoot;
    }

    private SpanEventRecorder wrappedSpanEventRecorder(WrappedSpanEventRecorder wrappedSpanEventRecorder, SpanEvent spanEvent) {
        wrappedSpanEventRecorder.setWrapped(spanEvent);
        return wrappedSpanEventRecorder;
    }

    public SpanEventRecorder traceBlockBegin() {
        return this.traceBlockBegin(-1);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        SpanEvent spanEvent = this.traceBlockBegin0(stackId);
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private SpanEvent traceBlockBegin0(int stackId) {
        if (this.closed) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("already closed trace");
            }
            return this.dummySpanEvent();
        }
        SpanEvent spanEvent = this.newSpanEvent(stackId);
        this.callStack.push(spanEvent);
        return spanEvent;
    }

    private void stackDump(String caused) {
        PinpointException exception = new PinpointException(caused);
        this.logger.warn("Corrupted call stack found TraceRoot:{}, CallStack:{}", (Object)this.getTraceRoot(), this.callStack, (Object)exception);
    }

    public void traceBlockEnd() {
        this.traceBlockEnd(-1);
    }

    public void traceBlockEnd(int stackId) {
        if (this.closed) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("already closed trace");
            }
            return;
        }
        SpanEvent spanEvent = this.callStack.pop();
        if (spanEvent == null) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("call stack is empty.");
            }
            return;
        }
        if (this.isDummySpanEvent(spanEvent)) {
            if (this.isDebug) {
                this.logger.debug("[{}] Skip dummy spanEvent", (Object)this);
            }
            return;
        }
        if (spanEvent.getStackId() != stackId && this.logger.isWarnEnabled()) {
            this.stackDump("not matched stack id. expected=" + stackId + ", current=" + spanEvent.getStackId());
        }
        if (spanEvent.isTimeRecording()) {
            spanEvent.markAfterTime();
        }
        this.logSpan(spanEvent);
        SpanEvent previous = this.callStack.peek();
        this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, previous);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.traceBlockEnd(1001);
        this.close0();
    }

    public void close0() {
        if (this.closed) {
            this.logger.warn("Already closed {}", (Object)this);
            return;
        }
        this.closed = true;
        if (!this.callStack.empty()) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("not empty call stack");
            }
        } else {
            this.logSpan();
        }
        this.wrappedSpanEventRecorder.close();
        this.storage.close();
    }

    public TraceId getTraceId() {
        return this.getTraceRoot().getTraceId();
    }

    public long getId() {
        return this.getTraceRoot().getLocalTransactionId();
    }

    public long getStartTime() {
        return this.getTraceRoot().getTraceStartTime();
    }

    public boolean canSampled() {
        return true;
    }

    public boolean isRoot() {
        return this.getTraceId().isRoot();
    }

    private void logSpan(SpanEvent spanEvent) {
        this.storage.store(spanEvent);
    }

    private void logSpan() {
        this.storage.flush();
    }

    public boolean isAsync() {
        return true;
    }

    public boolean isRootStack() {
        return this.getCallStackFrameId0() == 1001;
    }

    public int getCallStackFrameId0() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            return 0;
        }
        return spanEvent.getStackId();
    }

    public SpanRecorder getSpanRecorder() {
        return this.spanRecorder;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            if (this.logger.isWarnEnabled()) {
                this.stackDump("call stack is empty");
            }
            spanEvent = this.dummySpanEvent();
        }
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private SpanEvent newSpanEvent(int stackId) {
        SpanEvent spanEvent = this.callStack.newInstance();
        spanEvent.markStartTime();
        spanEvent.setStackId(stackId);
        return spanEvent;
    }

    @VisibleForTesting
    SpanEvent dummySpanEvent() {
        return this.callStack.disableInstance();
    }

    @VisibleForTesting
    boolean isDummySpanEvent(SpanEvent spanEvent) {
        return this.callStack.isDisable(spanEvent);
    }

    public int getCallStackFrameId() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            return 0;
        }
        return spanEvent.getStackId();
    }

    public TraceScope getScope(String name) {
        if (this.scopePool == null) {
            return null;
        }
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        if (this.scopePool == null) {
            this.scopePool = new DefaultTraceScopePool();
        }
        return this.scopePool.add(name);
    }

    public String toString() {
        return "ChildTrace{traceRoot=" + this.getTraceRoot() + ", localAsyncId=" + this.localAsyncId + '}';
    }
}

