/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.local;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedFileDataInput {
    private static final Logger logger = LoggerFactory.getLogger(BufferedFileDataInput.class);
    private File file;
    private int size;
    private FileInputStream fileInput;
    private BufferedInputStream bufferedInput;
    private DataInputStream dataInput;
    private long offset;
    private FileChannel fileChannel;

    public BufferedFileDataInput(File file, int size) throws FileNotFoundException, IOException, InterruptedException {
        this.file = file;
        this.size = size;
    }

    public BufferedFileDataInput(File file) throws FileNotFoundException, IOException, InterruptedException {
        this(file, 1024);
    }

    public long available() throws IOException {
        return this.fileChannel.size() - this.offset;
    }

    public long skip(long bytes) throws IOException {
        long bytesSkipped = this.bufferedInput.skip(bytes);
        this.offset += bytesSkipped;
        return bytesSkipped;
    }

    public void seek(long seekBytes) throws FileNotFoundException, IOException, InterruptedException {
        this.fileInput = new FileInputStream(this.file);
        this.fileChannel = this.fileInput.getChannel();
        try {
            this.fileChannel.position(seekBytes);
        }
        catch (ClosedByInterruptException e) {
            throw new InterruptedException();
        }
        this.bufferedInput = new BufferedInputStream(this.fileInput, this.size);
        this.dataInput = new DataInputStream(this.bufferedInput);
        this.offset = seekBytes;
    }

    public void readFully(byte[] bytes) throws IOException {
        this.readFully(bytes, 0, bytes.length);
    }

    public void readFully(byte[] bytes, int start, int len) throws IOException {
        this.dataInput.readFully(bytes, start, len);
        this.offset += (long)len;
    }

    public void close() {
        try {
            if (this.fileChannel != null) {
                this.fileChannel.close();
                this.fileInput.close();
            }
        }
        catch (IOException e) {
            logger.warn("Unable to close buffered file reader: file=" + this.file.getName() + " exception=" + e.getMessage());
        }
        this.fileChannel = null;
        this.fileInput = null;
        this.bufferedInput = null;
        this.dataInput = null;
        this.offset = -1L;
    }
}

