/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.dbsync;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.filter.aviater.AviaterRegexFilter;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.BinlogParser;
import com.alibaba.otter.canal.parse.inbound.TableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.TableMetaCache;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.DdlResult;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.DruidDdlParser;
import com.alibaba.otter.canal.parse.inbound.mysql.ddl.SimpleDdlParser;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import com.google.protobuf.ByteString;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.DeleteRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.GtidLogEvent;
import com.taobao.tddl.dbsync.binlog.event.HeartbeatLogEvent;
import com.taobao.tddl.dbsync.binlog.event.HeartbeatV2LogEvent;
import com.taobao.tddl.dbsync.binlog.event.IntvarLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;
import com.taobao.tddl.dbsync.binlog.event.QueryLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RandLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RowsLogBuffer;
import com.taobao.tddl.dbsync.binlog.event.RowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RowsQueryLogEvent;
import com.taobao.tddl.dbsync.binlog.event.TableMapLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UnknownLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UpdateRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UserVarLogEvent;
import com.taobao.tddl.dbsync.binlog.event.WriteRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.XidLogEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.AnnotateRowsEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.MariaGtidListLogEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.MariaGtidLogEvent;
import com.taobao.tddl.dbsync.binlog.exception.TableIdNotFoundException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEventConvert
extends AbstractCanalLifeCycle
implements BinlogParser<LogEvent> {
    public static final String XA_XID = "XA_XID";
    public static final String XA_TYPE = "XA_TYPE";
    public static final String XA_START = "XA START";
    public static final String XA_END = "XA END";
    public static final String XA_COMMIT = "XA COMMIT";
    public static final String XA_ROLLBACK = "XA ROLLBACK";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final int TINYINT_MAX_VALUE = 256;
    public static final int SMALLINT_MAX_VALUE = 65536;
    public static final int MEDIUMINT_MAX_VALUE = 0x1000000;
    public static final long INTEGER_MAX_VALUE = 0x100000000L;
    public static final BigInteger BIGINT_MAX_VALUE = new BigInteger("18446744073709551616");
    public static final int version = 1;
    public static final String BEGIN = "BEGIN";
    public static final String COMMIT = "COMMIT";
    public static final Logger logger = LoggerFactory.getLogger(LogEventConvert.class);
    private volatile AviaterRegexFilter nameFilter;
    private volatile AviaterRegexFilter nameBlackFilter;
    private Map<String, List<String>> fieldFilterMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> fieldBlackFilterMap = new HashMap<String, List<String>>();
    private TableMetaCache tableMetaCache;
    private Charset charset = Charset.defaultCharset();
    private boolean filterQueryDcl = false;
    private boolean filterQueryDml = false;
    private boolean filterQueryDdl = false;
    private boolean filterTableError = false;
    private boolean filterRows = false;
    private boolean useDruidDdlFilter = true;

    @Override
    public CanalEntry.Entry parse(LogEvent logEvent, boolean isSeek) throws CanalParseException {
        if (logEvent == null || logEvent instanceof UnknownLogEvent) {
            return null;
        }
        int eventType = logEvent.getHeader().getType();
        switch (eventType) {
            case 2: {
                return this.parseQueryEvent((QueryLogEvent)logEvent, isSeek);
            }
            case 16: {
                return this.parseXidEvent((XidLogEvent)logEvent);
            }
            case 19: {
                this.parseTableMapEvent((TableMapLogEvent)logEvent);
                break;
            }
            case 23: 
            case 30: {
                return this.parseRowsEvent((RowsLogEvent)((WriteRowsLogEvent)logEvent));
            }
            case 24: 
            case 31: 
            case 39: {
                return this.parseRowsEvent((RowsLogEvent)((UpdateRowsLogEvent)logEvent));
            }
            case 25: 
            case 32: {
                return this.parseRowsEvent((RowsLogEvent)((DeleteRowsLogEvent)logEvent));
            }
            case 29: {
                return this.parseRowsQueryEvent((RowsQueryLogEvent)logEvent);
            }
            case 160: {
                return this.parseAnnotateRowsEvent((AnnotateRowsEvent)logEvent);
            }
            case 14: {
                return this.parseUserVarLogEvent((UserVarLogEvent)logEvent);
            }
            case 5: {
                return this.parseIntrvarLogEvent((IntvarLogEvent)logEvent);
            }
            case 13: {
                return this.parseRandLogEvent((RandLogEvent)logEvent);
            }
            case 33: {
                return this.parseGTIDLogEvent((GtidLogEvent)logEvent);
            }
            case 27: {
                return this.parseHeartbeatLogEvent((HeartbeatLogEvent)logEvent);
            }
            case 41: {
                return this.parseHeartbeatV2LogEvent((HeartbeatV2LogEvent)logEvent);
            }
            case 162: 
            case 163: {
                return this.parseMariaGTIDLogEvent(logEvent);
            }
        }
        return null;
    }

    @Override
    public void reset() {
        if (this.tableMetaCache != null) {
            this.tableMetaCache.clearTableMeta();
        }
    }

    private CanalEntry.Entry parseHeartbeatLogEvent(HeartbeatLogEvent logEvent) {
        CanalEntry.Header.Builder headerBuilder = CanalEntry.Header.newBuilder();
        headerBuilder.setEventType(CanalEntry.EventType.MHEARTBEAT);
        CanalEntry.Entry.Builder entryBuilder = CanalEntry.Entry.newBuilder();
        entryBuilder.setHeader(headerBuilder.build());
        entryBuilder.setEntryType(CanalEntry.EntryType.HEARTBEAT);
        return entryBuilder.build();
    }

    private CanalEntry.Entry parseHeartbeatV2LogEvent(HeartbeatV2LogEvent logEvent) {
        CanalEntry.Header.Builder headerBuilder = CanalEntry.Header.newBuilder();
        headerBuilder.setEventType(CanalEntry.EventType.MHEARTBEAT);
        CanalEntry.Entry.Builder entryBuilder = CanalEntry.Entry.newBuilder();
        entryBuilder.setHeader(headerBuilder.build());
        entryBuilder.setEntryType(CanalEntry.EntryType.HEARTBEAT);
        return entryBuilder.build();
    }

    private CanalEntry.Entry parseGTIDLogEvent(GtidLogEvent logEvent) {
        LogHeader logHeader = logEvent.getHeader();
        CanalEntry.Pair.Builder builder = CanalEntry.Pair.newBuilder();
        builder.setKey("gtid");
        builder.setValue(logEvent.getGtidStr());
        if (logEvent.getLastCommitted() != -1L) {
            builder.setKey("lastCommitted");
            builder.setValue(String.valueOf(logEvent.getLastCommitted()));
            builder.setKey("sequenceNumber");
            builder.setValue(String.valueOf(logEvent.getSequenceNumber()));
        }
        CanalEntry.Header header = this.createHeader(logHeader, "", "", CanalEntry.EventType.GTID);
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.GTIDLOG, builder.build().toByteString());
    }

    private CanalEntry.Entry parseMariaGTIDLogEvent(LogEvent logEvent) {
        LogHeader logHeader = logEvent.getHeader();
        CanalEntry.Pair.Builder builder = CanalEntry.Pair.newBuilder();
        builder.setKey("gtid");
        if (logEvent instanceof MariaGtidLogEvent) {
            builder.setValue(((MariaGtidLogEvent)logEvent).getGtidStr());
        } else if (logEvent instanceof MariaGtidListLogEvent) {
            builder.setValue(((MariaGtidListLogEvent)logEvent).getGtidStr());
        }
        CanalEntry.Header header = this.createHeader(logHeader, "", "", CanalEntry.EventType.GTID);
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.GTIDLOG, builder.build().toByteString());
    }

    private CanalEntry.Entry parseQueryEvent(QueryLogEvent event, boolean isSeek) {
        boolean isDml;
        String queryString = event.getQuery();
        if (StringUtils.startsWithIgnoreCase((String)queryString, (String)XA_START)) {
            CanalEntry.TransactionBegin.Builder beginBuilder = CanalEntry.TransactionBegin.newBuilder();
            beginBuilder.setThreadId(event.getSessionId());
            beginBuilder.addProps(LogEventConvert.createSpecialPair(XA_TYPE, XA_START));
            beginBuilder.addProps(LogEventConvert.createSpecialPair(XA_XID, this.getXaXid(queryString, XA_START)));
            CanalEntry.TransactionBegin transactionBegin = beginBuilder.build();
            CanalEntry.Header header = this.createHeader(event.getHeader(), "", "", null);
            return LogEventConvert.createEntry(header, CanalEntry.EntryType.TRANSACTIONBEGIN, transactionBegin.toByteString());
        }
        if (StringUtils.startsWithIgnoreCase((String)queryString, (String)XA_END)) {
            CanalEntry.TransactionEnd.Builder endBuilder = CanalEntry.TransactionEnd.newBuilder();
            endBuilder.setTransactionId(String.valueOf(0L));
            endBuilder.addProps(LogEventConvert.createSpecialPair(XA_TYPE, XA_END));
            endBuilder.addProps(LogEventConvert.createSpecialPair(XA_XID, this.getXaXid(queryString, XA_END)));
            CanalEntry.TransactionEnd transactionEnd = endBuilder.build();
            CanalEntry.Header header = this.createHeader(event.getHeader(), "", "", null);
            return LogEventConvert.createEntry(header, CanalEntry.EntryType.TRANSACTIONEND, transactionEnd.toByteString());
        }
        if (StringUtils.startsWithIgnoreCase((String)queryString, (String)XA_COMMIT)) {
            CanalEntry.Header header = this.createHeader(event.getHeader(), "", "", CanalEntry.EventType.XACOMMIT);
            CanalEntry.RowChange.Builder rowChangeBuider = CanalEntry.RowChange.newBuilder();
            rowChangeBuider.setSql(queryString);
            rowChangeBuider.addProps(LogEventConvert.createSpecialPair(XA_TYPE, XA_COMMIT));
            rowChangeBuider.addProps(LogEventConvert.createSpecialPair(XA_XID, this.getXaXid(queryString, XA_COMMIT)));
            rowChangeBuider.setEventType(CanalEntry.EventType.XACOMMIT);
            return LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChangeBuider.build().toByteString());
        }
        if (StringUtils.startsWithIgnoreCase((String)queryString, (String)XA_ROLLBACK)) {
            CanalEntry.Header header = this.createHeader(event.getHeader(), "", "", CanalEntry.EventType.XAROLLBACK);
            CanalEntry.RowChange.Builder rowChangeBuider = CanalEntry.RowChange.newBuilder();
            rowChangeBuider.setSql(queryString);
            rowChangeBuider.addProps(LogEventConvert.createSpecialPair(XA_TYPE, XA_ROLLBACK));
            rowChangeBuider.addProps(LogEventConvert.createSpecialPair(XA_XID, this.getXaXid(queryString, XA_ROLLBACK)));
            rowChangeBuider.setEventType(CanalEntry.EventType.XAROLLBACK);
            return LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChangeBuider.build().toByteString());
        }
        if (StringUtils.endsWithIgnoreCase((String)queryString, (String)BEGIN)) {
            CanalEntry.TransactionBegin transactionBegin = LogEventConvert.createTransactionBegin(event.getSessionId());
            CanalEntry.Header header = this.createHeader(event.getHeader(), "", "", null);
            return LogEventConvert.createEntry(header, CanalEntry.EntryType.TRANSACTIONBEGIN, transactionBegin.toByteString());
        }
        if (StringUtils.endsWithIgnoreCase((String)queryString, (String)COMMIT)) {
            CanalEntry.TransactionEnd transactionEnd = LogEventConvert.createTransactionEnd(0L);
            CanalEntry.Header header = this.createHeader(event.getHeader(), "", "", null);
            return LogEventConvert.createEntry(header, CanalEntry.EntryType.TRANSACTIONEND, transactionEnd.toByteString());
        }
        boolean notFilter = false;
        CanalEntry.EventType type = CanalEntry.EventType.QUERY;
        String tableName = null;
        String schemaName = null;
        if (this.useDruidDdlFilter) {
            List<DdlResult> results = DruidDdlParser.parse(queryString, event.getDbName());
            for (DdlResult result : results) {
                if (this.processFilter(queryString, result)) continue;
                notFilter = true;
            }
            if (results.size() > 0) {
                type = results.get(0).getType();
                schemaName = results.get(0).getSchemaName();
                tableName = results.get(0).getTableName();
            }
        } else {
            DdlResult result = SimpleDdlParser.parse(queryString, event.getDbName());
            if (!this.processFilter(queryString, result)) {
                notFilter = true;
            }
            type = result.getType();
            schemaName = result.getSchemaName();
            tableName = result.getTableName();
        }
        if (!notFilter) {
            return null;
        }
        boolean bl = isDml = type == CanalEntry.EventType.INSERT || type == CanalEntry.EventType.UPDATE || type == CanalEntry.EventType.DELETE;
        if (!isSeek && !isDml) {
            EntryPosition position = this.createPosition(event.getHeader());
            this.tableMetaCache.apply(position, event.getDbName(), queryString, null);
        }
        if (this.filterQueryDdl) {
            return null;
        }
        CanalEntry.Header header = this.createHeader(event.getHeader(), schemaName, tableName, type);
        CanalEntry.RowChange.Builder rowChangeBuilder = CanalEntry.RowChange.newBuilder();
        rowChangeBuilder.setIsDdl(!isDml);
        rowChangeBuilder.setSql(queryString);
        if (StringUtils.isNotEmpty((String)event.getDbName())) {
            rowChangeBuilder.setDdlSchemaName(event.getDbName());
        }
        rowChangeBuilder.setEventType(type);
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChangeBuilder.build().toByteString());
    }

    private String getXaXid(String queryString, String type) {
        return StringUtils.substringAfter((String)queryString, (String)type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processFilter(String queryString, DdlResult result) {
        String schemaName = result.getSchemaName();
        String tableName = result.getTableName();
        if (this.tableMetaCache != null && (result.getType() == CanalEntry.EventType.ALTER || result.getType() == CanalEntry.EventType.ERASE || result.getType() == CanalEntry.EventType.RENAME)) {
            for (DdlResult renameResult = result; renameResult != null; renameResult = renameResult.getRenameTableResult()) {
                String schemaName0 = renameResult.getSchemaName();
                String tableName0 = renameResult.getTableName();
                if (StringUtils.isNotEmpty((String)tableName0)) {
                    this.tableMetaCache.clearTableMeta(schemaName0, tableName0);
                    continue;
                }
                this.tableMetaCache.clearTableMetaWithSchemaName(schemaName0);
            }
        }
        if (result.getType() == CanalEntry.EventType.ALTER || result.getType() == CanalEntry.EventType.ERASE || result.getType() == CanalEntry.EventType.CREATE || result.getType() == CanalEntry.EventType.TRUNCATE || result.getType() == CanalEntry.EventType.RENAME || result.getType() == CanalEntry.EventType.CINDEX || result.getType() == CanalEntry.EventType.DINDEX) {
            if (!this.filterQueryDdl && (StringUtils.isEmpty((String)tableName) || result.getType() == CanalEntry.EventType.RENAME && StringUtils.isEmpty((String)result.getOriTableName()))) {
                throw new CanalParseException("SimpleDdlParser process query failed. pls submit issue with this queryString: " + queryString + " , and DdlResult: " + result.toString());
            }
            String name = schemaName + "." + tableName;
            if (this.nameFilter != null && !this.nameFilter.filter(name)) {
                if (result.getType() != CanalEntry.EventType.RENAME) return true;
                if (this.nameFilter != null && !this.nameFilter.filter(result.getOriSchemaName() + "." + result.getOriTableName())) {
                    return true;
                }
            }
            if (this.nameBlackFilter == null || !this.nameBlackFilter.filter(name)) return false;
            if (result.getType() != CanalEntry.EventType.RENAME) return true;
            if (this.nameBlackFilter == null || !this.nameBlackFilter.filter(result.getOriSchemaName() + "." + result.getOriTableName())) return false;
            return true;
        }
        if (!(result.getType() == CanalEntry.EventType.INSERT || result.getType() == CanalEntry.EventType.UPDATE || result.getType() == CanalEntry.EventType.DELETE ? this.filterQueryDml : this.filterQueryDcl)) return false;
        return true;
    }

    private CanalEntry.Entry parseRowsQueryEvent(RowsQueryLogEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        String queryString = null;
        try {
            List<DdlResult> results;
            queryString = new String(event.getRowsQuery().getBytes(ISO_8859_1), this.charset);
            String tableName = null;
            if (this.useDruidDdlFilter && (results = DruidDdlParser.parse(queryString, null)).size() > 0) {
                tableName = results.get(0).getTableName();
            }
            return this.buildQueryEntry(queryString, event.getHeader(), tableName);
        }
        catch (UnsupportedEncodingException e) {
            throw new CanalParseException(e);
        }
    }

    private CanalEntry.Entry parseAnnotateRowsEvent(AnnotateRowsEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        String queryString = null;
        try {
            queryString = new String(event.getRowsQuery().getBytes(ISO_8859_1), this.charset);
            return this.buildQueryEntry(queryString, event.getHeader());
        }
        catch (UnsupportedEncodingException e) {
            throw new CanalParseException(e);
        }
    }

    private CanalEntry.Entry parseUserVarLogEvent(UserVarLogEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        return this.buildQueryEntry(event.getQuery(), event.getHeader());
    }

    private CanalEntry.Entry parseIntrvarLogEvent(IntvarLogEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        return this.buildQueryEntry(event.getQuery(), event.getHeader());
    }

    private CanalEntry.Entry parseRandLogEvent(RandLogEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        return this.buildQueryEntry(event.getQuery(), event.getHeader());
    }

    private CanalEntry.Entry parseXidEvent(XidLogEvent event) {
        CanalEntry.TransactionEnd transactionEnd = LogEventConvert.createTransactionEnd(event.getXid());
        CanalEntry.Header header = this.createHeader(event.getHeader(), "", "", null);
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.TRANSACTIONEND, transactionEnd.toByteString());
    }

    public TableMeta parseRowsEventForTableMeta(RowsLogEvent event) {
        TableMeta.FieldMeta idMeta;
        TableMapLogEvent table = event.getTable();
        if (table == null) {
            throw new TableIdNotFoundException("not found tableId:" + event.getTableId());
        }
        boolean isHeartBeat = this.isAliSQLHeartBeat(table.getDbName(), table.getTableName());
        boolean isRDSHeartBeat = this.tableMetaCache.isOnRDS() && this.isRDSHeartBeat(table.getDbName(), table.getTableName());
        String fullname = table.getDbName() + "." + table.getTableName();
        if (this.nameFilter != null && !this.nameFilter.filter(fullname)) {
            return null;
        }
        if (this.nameBlackFilter != null && this.nameBlackFilter.filter(fullname)) {
            return null;
        }
        TableMeta tableMeta = null;
        if (isRDSHeartBeat) {
            idMeta = new TableMeta.FieldMeta("id", "bigint(20)", true, false, "0");
            TableMeta.FieldMeta typeMeta = new TableMeta.FieldMeta("type", "char(1)", false, true, "0");
            tableMeta = new TableMeta(table.getDbName(), table.getTableName(), Arrays.asList(idMeta, typeMeta));
        } else if (isHeartBeat) {
            idMeta = new TableMeta.FieldMeta("id", "smallint(6)", false, true, null);
            TableMeta.FieldMeta typeMeta = new TableMeta.FieldMeta("ts", "int(11)", true, false, null);
            tableMeta = new TableMeta(table.getDbName(), table.getTableName(), Arrays.asList(idMeta, typeMeta));
        }
        EntryPosition position = this.createPosition(event.getHeader());
        if (this.tableMetaCache != null && tableMeta == null && (tableMeta = this.getTableMeta(table.getDbName(), table.getTableName(), true, position)) == null && !this.filterTableError) {
            throw new CanalParseException("not found [" + fullname + "] in db , pls check!");
        }
        return tableMeta;
    }

    public CanalEntry.Entry parseRowsEvent(RowsLogEvent event) {
        return this.parseRowsEvent(event, null);
    }

    public void parseTableMapEvent(TableMapLogEvent event) {
        try {
            String charsetDbName = new String(event.getDbName().getBytes(ISO_8859_1), this.charset);
            event.setDbname(charsetDbName);
            String charsetTbName = new String(event.getTableName().getBytes(ISO_8859_1), this.charset);
            event.setTblname(charsetTbName);
        }
        catch (UnsupportedEncodingException e) {
            throw new CanalParseException(e);
        }
    }

    public CanalEntry.Entry parseRowsEvent(RowsLogEvent event, TableMeta tableMeta) {
        if (this.filterRows) {
            return null;
        }
        try {
            if (tableMeta == null) {
                tableMeta = this.parseRowsEventForTableMeta(event);
            }
            if (tableMeta == null) {
                return null;
            }
            CanalEntry.EventType eventType = null;
            int type = event.getHeader().getType();
            if (23 == type || 30 == type) {
                eventType = CanalEntry.EventType.INSERT;
            } else if (24 == type || 31 == type || 39 == type) {
                eventType = CanalEntry.EventType.UPDATE;
            } else if (25 == type || 32 == type) {
                eventType = CanalEntry.EventType.DELETE;
            } else {
                throw new CanalParseException("unsupport event type :" + event.getHeader().getType());
            }
            CanalEntry.RowChange.Builder rowChangeBuider = CanalEntry.RowChange.newBuilder();
            rowChangeBuider.setTableId(event.getTableId());
            rowChangeBuider.setIsDdl(false);
            rowChangeBuider.setEventType(eventType);
            RowsLogBuffer buffer = event.getRowsBuf(this.charset);
            BitSet columns = event.getColumns();
            BitSet changeColumns = event.getChangeColumns();
            boolean tableError = false;
            int rowsCount = 0;
            while (buffer.nextOneRow(columns, false)) {
                CanalEntry.RowData.Builder rowDataBuilder = CanalEntry.RowData.newBuilder();
                if (CanalEntry.EventType.INSERT == eventType) {
                    tableError |= this.parseOneRow(rowDataBuilder, event, buffer, columns, true, tableMeta);
                } else if (CanalEntry.EventType.DELETE == eventType) {
                    tableError |= this.parseOneRow(rowDataBuilder, event, buffer, columns, false, tableMeta);
                } else {
                    tableError |= this.parseOneRow(rowDataBuilder, event, buffer, columns, false, tableMeta);
                    if (!buffer.nextOneRow(changeColumns, true)) {
                        rowChangeBuider.addRowDatas(rowDataBuilder.build());
                        break;
                    }
                    tableError |= this.parseOneRow(rowDataBuilder, event, buffer, changeColumns, true, tableMeta);
                }
                ++rowsCount;
                rowChangeBuider.addRowDatas(rowDataBuilder.build());
            }
            TableMapLogEvent table = event.getTable();
            CanalEntry.Header header = this.createHeader(event.getHeader(), table.getDbName(), table.getTableName(), eventType, rowsCount);
            CanalEntry.RowChange rowChange = rowChangeBuider.build();
            if (tableError) {
                CanalEntry.Entry entry = LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, ByteString.EMPTY);
                logger.warn("table parser error : {}storeValue: {}", (Object)entry.toString(), (Object)rowChange.toString());
                return null;
            }
            CanalEntry.Entry entry = LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChange.toByteString());
            return entry;
        }
        catch (Exception e) {
            throw new CanalParseException("parse row data failed.", e);
        }
    }

    private EntryPosition createPosition(LogHeader logHeader) {
        return new EntryPosition(logHeader.getLogFileName(), Long.valueOf(logHeader.getLogPos() - (long)logHeader.getEventLen()), Long.valueOf(logHeader.getWhen() * 1000L), Long.valueOf(logHeader.getServerId()));
    }

    private boolean parseOneRow(CanalEntry.RowData.Builder rowDataBuilder, RowsLogEvent event, RowsLogBuffer buffer, BitSet cols, boolean isAfter, TableMeta tableMeta) throws UnsupportedEncodingException {
        int columnCnt = event.getTable().getColumnCnt();
        TableMapLogEvent.ColumnInfo[] columnInfo = event.getTable().getColumnInfo();
        boolean existOptionalMetaData = event.getTable().isExistOptionalMetaData();
        boolean tableError = false;
        boolean existRDSNoPrimaryKey = false;
        List<String> fieldList = null;
        List<String> blackFieldList = null;
        if (tableMeta != null) {
            fieldList = this.fieldFilterMap.get(tableMeta.getFullName().toUpperCase());
            blackFieldList = this.fieldBlackFilterMap.get(tableMeta.getFullName().toUpperCase());
        }
        if (tableMeta != null && columnInfo.length > tableMeta.getFields().size()) {
            List<TableMeta.FieldMeta> primaryKeys;
            if ((this.tableMetaCache.isOnRDS() || this.tableMetaCache.isOnPolarX()) && ((primaryKeys = tableMeta.getPrimaryFields()) == null || primaryKeys.isEmpty()) && columnInfo.length == tableMeta.getFields().size() + 1 && columnInfo[columnInfo.length - 1].type == 8) {
                existRDSNoPrimaryKey = true;
            }
            EntryPosition position = this.createPosition(event.getHeader());
            if (!existRDSNoPrimaryKey) {
                tableMeta = this.getTableMeta(event.getTable().getDbName(), event.getTable().getTableName(), false, position);
                if (tableMeta == null) {
                    tableError = true;
                    if (!this.filterTableError) {
                        throw new CanalParseException("not found [" + event.getTable().getDbName() + "." + event.getTable().getTableName() + "] in db , pls check!");
                    }
                }
                if (tableMeta != null && columnInfo.length > tableMeta.getFields().size()) {
                    tableError = true;
                    if (!this.filterTableError) {
                        throw new CanalParseException("column size is not match for table:" + tableMeta.getFullName() + "," + columnInfo.length + " vs " + tableMeta.getFields().size());
                    }
                }
            }
        }
        for (int i = 0; i < columnCnt; ++i) {
            CanalEntry.Column.Builder columnBuilder;
            TableMapLogEvent.ColumnInfo info = columnInfo[i];
            if (!cols.get(i)) continue;
            if (existRDSNoPrimaryKey && i == columnCnt - 1 && info.type == 8) {
                String rdsRowIdColumnName = "__#alibaba_rds_row_id#__";
                if (this.tableMetaCache.isOnPolarX()) {
                    rdsRowIdColumnName = "_drds_implicit_id_";
                }
                buffer.nextValue(rdsRowIdColumnName, i, info.type, info.meta, false);
                columnBuilder = CanalEntry.Column.newBuilder();
                columnBuilder.setName(rdsRowIdColumnName);
                columnBuilder.setIsKey(true);
                columnBuilder.setMysqlType("bigint");
                columnBuilder.setIndex(i);
                columnBuilder.setIsNull(false);
                Serializable value = buffer.getValue();
                columnBuilder.setValue(value.toString());
                columnBuilder.setSqlType(-5);
                columnBuilder.setUpdated(false);
                if (!this.needField(fieldList, blackFieldList, columnBuilder.getName())) continue;
                if (isAfter) {
                    rowDataBuilder.addAfterColumns(columnBuilder.build());
                    continue;
                }
                rowDataBuilder.addBeforeColumns(columnBuilder.build());
                continue;
            }
            TableMeta.FieldMeta fieldMeta = null;
            if (tableMeta != null && !tableError) {
                fieldMeta = tableMeta.getFields().get(i);
            }
            if (fieldMeta != null && existOptionalMetaData && this.tableMetaCache.isOnTSDB()) {
                boolean check = StringUtils.equalsIgnoreCase((String)fieldMeta.getColumnName(), (String)info.name);
                check &= fieldMeta.isUnsigned() == info.unsigned;
                if (!(check &= fieldMeta.isNullable() == info.nullable)) {
                    throw new CanalParseException("MySQL8.0 unmatch column metadata & pls submit issue , table : " + tableMeta.getFullName() + ", db fieldMeta : " + fieldMeta.toString() + " , binlog fieldMeta : " + info.toString() + " , on : " + event.getHeader().getLogFileName() + ":" + (event.getHeader().getLogPos() - (long)event.getHeader().getEventLen()));
                }
            }
            columnBuilder = CanalEntry.Column.newBuilder();
            if (fieldMeta != null) {
                columnBuilder.setName(fieldMeta.getColumnName());
                columnBuilder.setIsKey(fieldMeta.isKey());
                columnBuilder.setMysqlType(fieldMeta.getColumnType());
            } else if (existOptionalMetaData) {
                columnBuilder.setName(info.name);
                columnBuilder.setIsKey(info.pk);
            }
            columnBuilder.setIndex(i);
            columnBuilder.setIsNull(false);
            boolean isBinary = false;
            if (fieldMeta != null) {
                if (StringUtils.containsIgnoreCase((String)fieldMeta.getColumnType(), (String)"VARBINARY")) {
                    isBinary = true;
                } else if (StringUtils.containsIgnoreCase((String)fieldMeta.getColumnType(), (String)"BINARY")) {
                    isBinary = true;
                }
            }
            buffer.nextValue(columnBuilder.getName(), i, info.type, info.meta, isBinary);
            int javaType = buffer.getJavaType();
            if (buffer.isNull()) {
                columnBuilder.setIsNull(true);
                switch (javaType) {
                    case -4: 
                    case -3: 
                    case -2: {
                        javaType = fieldMeta != null && this.isText(fieldMeta.getColumnType()) ? 2005 : 2004;
                    }
                }
            } else {
                Serializable value = buffer.getValue();
                switch (javaType) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        boolean isUnsigned;
                        Number number = (Number)value;
                        boolean bl = fieldMeta != null ? fieldMeta.isUnsigned() : (isUnsigned = existOptionalMetaData ? info.unsigned : false);
                        if (isUnsigned && number.longValue() < 0L) {
                            switch (buffer.getLength()) {
                                case 1: {
                                    columnBuilder.setValue(String.valueOf((Object)(256 + number.intValue())));
                                    javaType = 5;
                                    break;
                                }
                                case 2: {
                                    columnBuilder.setValue(String.valueOf((Object)(65536 + number.intValue())));
                                    javaType = 4;
                                    break;
                                }
                                case 3: {
                                    columnBuilder.setValue(String.valueOf((Object)(0x1000000 + number.intValue())));
                                    javaType = 4;
                                    break;
                                }
                                case 4: {
                                    columnBuilder.setValue(String.valueOf((Object)(0x100000000L + number.longValue())));
                                    javaType = -5;
                                    break;
                                }
                                case 8: {
                                    columnBuilder.setValue(BIGINT_MAX_VALUE.add(BigInteger.valueOf(number.longValue())).toString());
                                    javaType = 3;
                                }
                            }
                            break;
                        }
                        columnBuilder.setValue(String.valueOf(value));
                        break;
                    }
                    case 7: 
                    case 8: {
                        columnBuilder.setValue(String.valueOf(value));
                        break;
                    }
                    case -7: {
                        columnBuilder.setValue(String.valueOf(value));
                        break;
                    }
                    case 3: {
                        columnBuilder.setValue(((BigDecimal)value).toPlainString());
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        columnBuilder.setValue(value.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (fieldMeta != null && this.isText(fieldMeta.getColumnType())) {
                            columnBuilder.setValue(new String((byte[])value, this.charset));
                            javaType = 2005;
                            break;
                        }
                        columnBuilder.setValue(new String((byte[])value, ISO_8859_1));
                        javaType = 2004;
                        break;
                    }
                    case 1: 
                    case 12: {
                        columnBuilder.setValue(value.toString());
                        break;
                    }
                    default: {
                        columnBuilder.setValue(value.toString());
                    }
                }
            }
            columnBuilder.setSqlType(javaType);
            columnBuilder.setUpdated(isAfter && this.isUpdate(rowDataBuilder.getBeforeColumnsList(), columnBuilder.getIsNull() ? null : columnBuilder.getValue(), i));
            if (!this.needField(fieldList, blackFieldList, columnBuilder.getName())) continue;
            if (isAfter) {
                rowDataBuilder.addAfterColumns(columnBuilder.build());
                continue;
            }
            rowDataBuilder.addBeforeColumns(columnBuilder.build());
        }
        return tableError;
    }

    private CanalEntry.Entry buildQueryEntry(String queryString, LogHeader logHeader, String tableName) {
        CanalEntry.Header header = this.createHeader(logHeader, "", tableName, CanalEntry.EventType.QUERY);
        CanalEntry.RowChange.Builder rowChangeBuider = CanalEntry.RowChange.newBuilder();
        rowChangeBuider.setSql(queryString);
        rowChangeBuider.setEventType(CanalEntry.EventType.QUERY);
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChangeBuider.build().toByteString());
    }

    private CanalEntry.Entry buildQueryEntry(String queryString, LogHeader logHeader) {
        CanalEntry.Header header = this.createHeader(logHeader, "", "", CanalEntry.EventType.QUERY);
        CanalEntry.RowChange.Builder rowChangeBuider = CanalEntry.RowChange.newBuilder();
        rowChangeBuider.setSql(queryString);
        rowChangeBuider.setEventType(CanalEntry.EventType.QUERY);
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChangeBuider.build().toByteString());
    }

    private CanalEntry.Header createHeader(LogHeader logHeader, String schemaName, String tableName, CanalEntry.EventType eventType) {
        return this.createHeader(logHeader, schemaName, tableName, eventType, -1);
    }

    private CanalEntry.Header createHeader(LogHeader logHeader, String schemaName, String tableName, CanalEntry.EventType eventType, Integer rowsCount) {
        CanalEntry.Pair pair;
        CanalEntry.Header.Builder headerBuilder = CanalEntry.Header.newBuilder();
        headerBuilder.setVersion(1);
        headerBuilder.setLogfileName(logHeader.getLogFileName());
        headerBuilder.setLogfileOffset(logHeader.getLogPos() - (long)logHeader.getEventLen());
        headerBuilder.setServerId(logHeader.getServerId());
        headerBuilder.setServerenCode(UTF_8);
        headerBuilder.setExecuteTime(logHeader.getWhen() * 1000L);
        headerBuilder.setSourceType(CanalEntry.Type.MYSQL);
        if (eventType != null) {
            headerBuilder.setEventType(eventType);
        }
        if (schemaName != null) {
            headerBuilder.setSchemaName(schemaName);
        }
        if (tableName != null) {
            headerBuilder.setTableName(tableName);
        }
        headerBuilder.setEventLength((long)logHeader.getEventLen());
        if (StringUtils.isNotEmpty((String)logHeader.getGtidSetStr())) {
            headerBuilder.setGtid(logHeader.getGtidSetStr());
        }
        if (StringUtils.isNotEmpty((String)logHeader.getCurrentGtid())) {
            pair = LogEventConvert.createSpecialPair("curtGtid", logHeader.getCurrentGtid());
            headerBuilder.addProps(pair);
        }
        if (StringUtils.isNotEmpty((String)logHeader.getCurrentGtidSn())) {
            pair = LogEventConvert.createSpecialPair("curtGtidSn", logHeader.getCurrentGtidSn());
            headerBuilder.addProps(pair);
        }
        if (StringUtils.isNotEmpty((String)logHeader.getCurrentGtidLastCommit())) {
            pair = LogEventConvert.createSpecialPair("curtGtidLct", logHeader.getCurrentGtidLastCommit());
            headerBuilder.addProps(pair);
        }
        if (rowsCount > 0) {
            pair = LogEventConvert.createSpecialPair("rowsCount", String.valueOf(rowsCount));
            headerBuilder.addProps(pair);
        }
        return headerBuilder.build();
    }

    private boolean isUpdate(List<CanalEntry.Column> bfColumns, String newValue, int index) {
        if (bfColumns == null) {
            throw new CanalParseException("ERROR ## the bfColumns is null");
        }
        if (index < 0) {
            return false;
        }
        for (CanalEntry.Column column : bfColumns) {
            if (column.getIndex() != index) continue;
            if (column.getIsNull() && newValue == null) {
                return false;
            }
            if (newValue == null || column.getIsNull() || !column.getValue().equals(newValue)) continue;
            return false;
        }
        return true;
    }

    private TableMeta getTableMeta(String dbName, String tbName, boolean useCache, EntryPosition position) {
        try {
            return this.tableMetaCache.getTableMeta(dbName, tbName, useCache, position);
        }
        catch (Throwable e) {
            String message = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (this.filterTableError) {
                if (StringUtils.contains((String)message, (String)"errorNumber=1146") && StringUtils.contains((String)message, (String)"doesn't exist")) {
                    return null;
                }
                if (StringUtils.contains((String)message, (String)"errorNumber=1142") && StringUtils.contains((String)message, (String)"command denied")) {
                    return null;
                }
            }
            throw new CanalParseException(e);
        }
    }

    private boolean isText(String columnType) {
        return "LONGTEXT".equalsIgnoreCase(columnType) || "MEDIUMTEXT".equalsIgnoreCase(columnType) || "TEXT".equalsIgnoreCase(columnType) || "TINYTEXT".equalsIgnoreCase(columnType);
    }

    private boolean isAliSQLHeartBeat(String schema, String table) {
        return "test".equalsIgnoreCase(schema) && "heartbeat".equalsIgnoreCase(table);
    }

    private boolean isRDSHeartBeat(String schema, String table) {
        return "mysql".equalsIgnoreCase(schema) && "ha_health_check".equalsIgnoreCase(table);
    }

    private boolean needField(List<String> fieldList, List<String> blackFieldList, String columnName) {
        if (fieldList == null || fieldList.isEmpty()) {
            return blackFieldList == null || blackFieldList.isEmpty() || !blackFieldList.contains(columnName.toUpperCase());
        }
        return fieldList.contains(columnName.toUpperCase());
    }

    public static CanalEntry.TransactionBegin createTransactionBegin(long threadId) {
        CanalEntry.TransactionBegin.Builder beginBuilder = CanalEntry.TransactionBegin.newBuilder();
        beginBuilder.setThreadId(threadId);
        return beginBuilder.build();
    }

    public static CanalEntry.TransactionEnd createTransactionEnd(long transactionId) {
        CanalEntry.TransactionEnd.Builder endBuilder = CanalEntry.TransactionEnd.newBuilder();
        endBuilder.setTransactionId(String.valueOf(transactionId));
        return endBuilder.build();
    }

    public static CanalEntry.Pair createSpecialPair(String key, String value) {
        CanalEntry.Pair.Builder pairBuilder = CanalEntry.Pair.newBuilder();
        pairBuilder.setKey(key);
        pairBuilder.setValue(value);
        return pairBuilder.build();
    }

    public static CanalEntry.Entry createEntry(CanalEntry.Header header, CanalEntry.EntryType entryType, ByteString storeValue) {
        CanalEntry.Entry.Builder entryBuilder = CanalEntry.Entry.newBuilder();
        entryBuilder.setHeader(header);
        entryBuilder.setEntryType(entryType);
        entryBuilder.setStoreValue(storeValue);
        return entryBuilder.build();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setNameFilter(AviaterRegexFilter nameFilter) {
        this.nameFilter = nameFilter;
        logger.warn("--> init table filter : " + nameFilter.toString());
    }

    public void setNameBlackFilter(AviaterRegexFilter nameBlackFilter) {
        this.nameBlackFilter = nameBlackFilter;
        logger.warn("--> init table black filter : " + nameBlackFilter.toString());
    }

    public void setFieldFilterMap(Map<String, List<String>> fieldFilterMap) {
        this.fieldFilterMap = fieldFilterMap != null ? fieldFilterMap : new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.fieldFilterMap.entrySet()) {
            logger.warn("--> init field filter : " + entry.getKey() + "->" + entry.getValue());
        }
    }

    public void setFieldBlackFilterMap(Map<String, List<String>> fieldBlackFilterMap) {
        this.fieldBlackFilterMap = fieldBlackFilterMap != null ? fieldBlackFilterMap : new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.fieldBlackFilterMap.entrySet()) {
            logger.warn("--> init field black filter : " + entry.getKey() + "->" + entry.getValue());
        }
    }

    public void setTableMetaCache(TableMetaCache tableMetaCache) {
        this.tableMetaCache = tableMetaCache;
    }

    public void setFilterQueryDcl(boolean filterQueryDcl) {
        this.filterQueryDcl = filterQueryDcl;
    }

    public void setFilterQueryDml(boolean filterQueryDml) {
        this.filterQueryDml = filterQueryDml;
    }

    public void setFilterQueryDdl(boolean filterQueryDdl) {
        this.filterQueryDdl = filterQueryDdl;
    }

    public void setFilterTableError(boolean filterTableError) {
        this.filterTableError = filterTableError;
    }

    public void setFilterRows(boolean filterRows) {
        this.filterRows = filterRows;
    }

    public void setUseDruidDdlFilter(boolean useDruidDdlFilter) {
        this.useDruidDdlFilter = useDruidDdlFilter;
    }
}

