/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client;

import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.grpc.ChannelTypeEnum;
import com.navercorp.pinpoint.grpc.ExecutorUtils;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.ChannelType;
import com.navercorp.pinpoint.grpc.client.ChannelTypeFactory;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import com.navercorp.pinpoint.grpc.client.config.ClientOption;
import com.navercorp.pinpoint.grpc.client.config.ClientRetryOption;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultChannelFactory
implements ChannelFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String factoryName;
    private final int executorQueueSize;
    private final HeaderFactory headerFactory;
    private final ClientOption clientOption;
    private final SslContext sslContext;
    private final ClientRetryOption clientRetryOption;
    private final List<ClientInterceptor> clientInterceptorList;
    private final NameResolverProvider nameResolverProvider;
    private final EventLoopGroup eventLoopGroup;
    private final ExecutorService eventLoopExecutor;
    private final ExecutorService executorService;
    private final Class<? extends Channel> channelType;

    DefaultChannelFactory(String factoryName, int executorQueueSize, HeaderFactory headerFactory, NameResolverProvider nameResolverProvider, ClientOption clientOption, List<ClientInterceptor> clientInterceptorList, SslContext sslContext, ClientRetryOption clientRetryOption) {
        this.factoryName = Objects.requireNonNull(factoryName, "factoryName");
        this.executorQueueSize = executorQueueSize;
        this.headerFactory = Objects.requireNonNull(headerFactory, "headerFactory");
        this.nameResolverProvider = nameResolverProvider;
        this.clientOption = Objects.requireNonNull(clientOption, "clientOption");
        Objects.requireNonNull(clientInterceptorList, "clientInterceptorList");
        this.clientInterceptorList = new ArrayList<ClientInterceptor>(clientInterceptorList);
        this.sslContext = sslContext;
        this.clientRetryOption = clientRetryOption;
        ChannelType channelType = this.getChannelType();
        this.channelType = channelType.getChannelType();
        this.eventLoopExecutor = this.newCachedExecutorService(factoryName + "-Channel-Worker");
        this.eventLoopGroup = channelType.newEventLoopGroup(1, this.eventLoopExecutor);
        this.executorService = this.newExecutorService(factoryName + "-Channel-Executor", this.executorQueueSize);
    }

    @Override
    public String getFactoryName() {
        return this.factoryName;
    }

    private ChannelType getChannelType() {
        ChannelTypeFactory factory = new ChannelTypeFactory();
        ChannelTypeEnum channelTypeEnum = this.clientOption.getChannelTypeEnum();
        return factory.newChannelType(channelTypeEnum);
    }

    private ExecutorService newCachedExecutorService(String name) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory("Pinpoint-" + name, true);
        return Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    private ExecutorService newExecutorService(String name, int executorQueueSize) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory("Pinpoint-" + name, true);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(executorQueueSize);
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, workQueue, (ThreadFactory)threadFactory);
    }

    @Override
    public ManagedChannel build(String host, int port) {
        return this.build(this.factoryName, host, port);
    }

    @Override
    public ManagedChannel build(String channelName, String host, int port) {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
        channelBuilder.usePlaintext();
        this.logger.info("ChannelType:{}", (Object)this.channelType.getSimpleName());
        channelBuilder.channelType(this.channelType);
        channelBuilder.eventLoopGroup(this.eventLoopGroup);
        this.setupInternal(channelBuilder);
        this.addHeader(channelBuilder);
        this.addClientInterceptor(channelBuilder);
        channelBuilder.executor((Executor)this.executorService);
        if (this.nameResolverProvider != null) {
            this.logger.info("Set nameResolverProvider {}. channelName={}, host={}, port={}", (Object)this.nameResolverProvider, (Object)channelName, (Object)host, (Object)port);
            this.setNameResolverFactory(channelBuilder, this.nameResolverProvider);
        }
        this.setupClientOption(channelBuilder);
        if (this.sslContext != null) {
            this.logger.info("{} enable SslContext", (Object)channelName);
            channelBuilder.sslContext(this.sslContext);
            channelBuilder.negotiationType(NegotiationType.TLS);
        }
        if (this.clientRetryOption != null) {
            this.setupRetryOption(channelBuilder);
        }
        channelBuilder.maxTraceEvents(this.clientOption.getMaxTraceEvent());
        return channelBuilder.build();
    }

    private void setNameResolverFactory(NettyChannelBuilder channelBuilder, NameResolverProvider nameResolverProvider) {
        channelBuilder.nameResolverFactory((NameResolver.Factory)nameResolverProvider);
    }

    private void setupInternal(NettyChannelBuilder channelBuilder) {
        InternalNettyChannelBuilder.setTracingEnabled((NettyChannelBuilder)channelBuilder, (boolean)false);
        InternalNettyChannelBuilder.setStatsEnabled((NettyChannelBuilder)channelBuilder, (boolean)false);
        InternalNettyChannelBuilder.setStatsRecordStartedRpcs((NettyChannelBuilder)channelBuilder, (boolean)false);
        InternalNettyChannelBuilder.setStatsRecordFinishedRpcs((NettyChannelBuilder)channelBuilder, (boolean)false);
        InternalNettyChannelBuilder.setStatsRecordRealTimeMetrics((NettyChannelBuilder)channelBuilder, (boolean)false);
    }

    private void addHeader(NettyChannelBuilder channelBuilder) {
        Metadata extraHeaders = this.headerFactory.newHeader();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addHeader {}", (Object)extraHeaders);
        }
        ClientInterceptor headersInterceptor = MetadataUtils.newAttachHeadersInterceptor((Metadata)extraHeaders);
        channelBuilder.intercept(new ClientInterceptor[]{headersInterceptor});
    }

    private void addClientInterceptor(NettyChannelBuilder channelBuilder) {
        channelBuilder.intercept(this.clientInterceptorList);
    }

    private void setupClientOption(NettyChannelBuilder channelBuilder) {
        channelBuilder.keepAliveTime(this.clientOption.getKeepAliveTime(), TimeUnit.MILLISECONDS);
        channelBuilder.keepAliveTimeout(this.clientOption.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
        channelBuilder.keepAliveWithoutCalls(this.clientOption.isKeepAliveWithoutCalls());
        channelBuilder.maxInboundMetadataSize(this.clientOption.getMaxHeaderListSize());
        channelBuilder.maxInboundMessageSize(this.clientOption.getMaxInboundMessageSize());
        channelBuilder.flowControlWindow(this.clientOption.getFlowControlWindow());
        channelBuilder.idleTimeout(this.clientOption.getIdleTimeoutMillis(), TimeUnit.MILLISECONDS);
        channelBuilder.defaultLoadBalancingPolicy(this.clientOption.getDefaultLoadBalancer());
        channelBuilder.withOption(ChannelOption.TCP_NODELAY, (Object)true);
        channelBuilder.withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.clientOption.getConnectTimeout());
        WriteBufferWaterMark writeBufferWaterMark = new WriteBufferWaterMark(this.clientOption.getWriteBufferLowWaterMark(), this.clientOption.getWriteBufferHighWaterMark());
        channelBuilder.withOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)writeBufferWaterMark);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Set clientOption {}. name={}", (Object)this.clientOption, (Object)this.factoryName);
        }
    }

    private void setupRetryOption(NettyChannelBuilder channelBuilder) {
        channelBuilder.enableRetry();
        channelBuilder.retryBufferSize(this.clientRetryOption.getRetryBufferSize());
        channelBuilder.perRpcBufferLimit(this.clientRetryOption.getPerRpcBufferLimit());
        channelBuilder.defaultServiceConfig(this.clientRetryOption.getRetryServiceConfig());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Set clientRetryOption {}. name={}", (Object)this.clientRetryOption, (Object)this.factoryName);
        }
    }

    @Override
    public void close() {
        Future future = this.eventLoopGroup.shutdownGracefully();
        try {
            this.logger.debug("shutdown {}-eventLoopGroup", (Object)this.factoryName);
            future.await(3000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ExecutorUtils.shutdownExecutorService(this.factoryName + "-eventLoopExecutor", this.eventLoopExecutor);
        ExecutorUtils.shutdownExecutorService(this.factoryName + "-executorService", this.executorService);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultChannelFactory{");
        sb.append("factoryName='").append(this.factoryName).append('\'');
        sb.append(", executorQueueSize=").append(this.executorQueueSize);
        sb.append(", headerFactory=").append(this.headerFactory);
        sb.append(", clientOption=").append(this.clientOption);
        sb.append(", clientInterceptorList=").append(this.clientInterceptorList);
        sb.append(", nameResolverProvider=").append(this.nameResolverProvider);
        sb.append(", eventLoopGroup=").append(this.eventLoopGroup);
        sb.append(", eventLoopExecutor=").append(this.eventLoopExecutor);
        sb.append(", executorService=").append(this.executorService);
        sb.append('}');
        return sb.toString();
    }
}

