/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc;

import io.grpc.Channel;
import io.grpc.InternalWithLogId;
import io.grpc.ManagedChannel;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ManagedChannelUtils {
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 3000L;
    private static final Logger logger = LogManager.getLogger(ManagedChannelUtils.class);
    private static final String LOG_ID_STR = "logId=";

    private ManagedChannelUtils() {
    }

    public static boolean shutdownManagedChannel(String name, ManagedChannel managedChannel) {
        return ManagedChannelUtils.shutdownManagedChannel(name, managedChannel, 3000L, TimeUnit.MILLISECONDS);
    }

    public static boolean shutdownManagedChannel(String name, ManagedChannel managedChannel, long timeout, TimeUnit unit) {
        if (managedChannel == null) {
            return false;
        }
        logger.debug("shutdown {}", (Object)name);
        managedChannel.shutdown();
        try {
            boolean success = managedChannel.awaitTermination(timeout, unit);
            if (!success) {
                logger.warn("shutdown timeout {}", (Object)name);
            }
            return success;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static long getLogId(Channel channel) {
        if (channel == null) {
            return -1L;
        }
        if (channel instanceof InternalWithLogId) {
            InternalWithLogId logId = (InternalWithLogId)channel;
            return logId.getLogId().getId();
        }
        String channelString = channel.toString();
        int start = channelString.indexOf(LOG_ID_STR);
        if (start == -1) {
            return -1L;
        }
        int end = channelString.indexOf(44, start + LOG_ID_STR.length());
        if (end == -1) {
            return -1L;
        }
        String logId = channelString.substring(start + LOG_ID_STR.length(), end);
        return Long.parseLong(logId);
    }
}

