/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExecutorUtils {
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 3000L;
    private static final Logger logger = LogManager.getLogger(ExecutorUtils.class);

    private ExecutorUtils() {
    }

    public static boolean shutdownExecutorService(String name, ExecutorService executorService) {
        return ExecutorUtils.shutdownExecutorService(name, executorService, 3000L, TimeUnit.MILLISECONDS);
    }

    public static boolean shutdownExecutorService(String name, ExecutorService executorService, long timeout, TimeUnit unit) {
        if (executorService == null) {
            return false;
        }
        logger.debug("shutdown {}", (Object)name);
        executorService.shutdown();
        try {
            boolean success = executorService.awaitTermination(timeout, unit);
            if (!success) {
                logger.warn("shutdown timeout {}", (Object)name);
            }
            return success;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

