/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl.eventmeshmessage;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPPubClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPSubClient;
import org.apache.eventmesh.client.tcp.common.AsyncRRCallback;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.client.tcp.impl.eventmeshmessage.EventMeshMessageTCPPubClient;
import org.apache.eventmesh.client.tcp.impl.eventmeshmessage.EventMeshMessageTCPSubClient;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Package;

public class EventMeshMessageTCPClient
implements EventMeshTCPClient<EventMeshMessage> {
    private final EventMeshTCPPubClient<EventMeshMessage> eventMeshMessageTCPPubClient;
    private final EventMeshTCPSubClient<EventMeshMessage> eventMeshMessageTCPSubClient;

    public EventMeshMessageTCPClient(EventMeshTCPClientConfig eventMeshTcpClientConfig) {
        this.eventMeshMessageTCPPubClient = new EventMeshMessageTCPPubClient(eventMeshTcpClientConfig);
        this.eventMeshMessageTCPSubClient = new EventMeshMessageTCPSubClient(eventMeshTcpClientConfig);
    }

    @Override
    public void init() throws EventMeshException {
        this.eventMeshMessageTCPPubClient.init();
        this.eventMeshMessageTCPSubClient.init();
    }

    @Override
    public Package rr(EventMeshMessage eventMeshMessage, long timeout) throws EventMeshException {
        this.validateMessage(eventMeshMessage);
        return this.eventMeshMessageTCPPubClient.rr(eventMeshMessage, timeout);
    }

    @Override
    public void asyncRR(EventMeshMessage eventMeshMessage, AsyncRRCallback callback, long timeout) throws EventMeshException {
        this.validateMessage(eventMeshMessage);
        this.eventMeshMessageTCPPubClient.asyncRR(eventMeshMessage, callback, timeout);
    }

    @Override
    public Package publish(EventMeshMessage eventMeshMessage, long timeout) throws EventMeshException {
        this.validateMessage(eventMeshMessage);
        return this.eventMeshMessageTCPPubClient.publish(eventMeshMessage, timeout);
    }

    @Override
    public void broadcast(EventMeshMessage eventMeshMessage, long timeout) throws EventMeshException {
        this.validateMessage(eventMeshMessage);
        this.eventMeshMessageTCPPubClient.broadcast(eventMeshMessage, timeout);
    }

    @Override
    public void listen() throws EventMeshException {
        this.eventMeshMessageTCPSubClient.listen();
    }

    @Override
    public void subscribe(String topic, SubscriptionMode subscriptionMode, SubscriptionType subscriptionType) throws EventMeshException {
        this.eventMeshMessageTCPSubClient.subscribe(topic, subscriptionMode, subscriptionType);
    }

    @Override
    public void unsubscribe() throws EventMeshException {
        this.eventMeshMessageTCPSubClient.unsubscribe();
    }

    @Override
    public void registerPubBusiHandler(ReceiveMsgHook<EventMeshMessage> handler) throws EventMeshException {
        this.eventMeshMessageTCPPubClient.registerBusiHandler(handler);
    }

    @Override
    public void registerSubBusiHandler(ReceiveMsgHook<EventMeshMessage> handler) throws EventMeshException {
        this.eventMeshMessageTCPSubClient.registerBusiHandler(handler);
    }

    @Override
    public void close() throws EventMeshException {
        try {
            this.eventMeshMessageTCPPubClient.close();
        }
        catch (Exception e) {
            throw new EventMeshException((Throwable)e);
        }
        try {
            this.eventMeshMessageTCPSubClient.close();
        }
        catch (Exception e) {
            throw new EventMeshException((Throwable)e);
        }
    }

    @Override
    public EventMeshTCPPubClient<EventMeshMessage> getPubClient() {
        return this.eventMeshMessageTCPPubClient;
    }

    @Override
    public EventMeshTCPSubClient<EventMeshMessage> getSubClient() {
        return this.eventMeshMessageTCPSubClient;
    }

    private void validateMessage(EventMeshMessage message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)message.getTopic()), (Object)"Message's topic cannot be null and blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)message.getBody()), (Object)"Message's body cannot be null and blank");
    }
}

