/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import lombok.Generated;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.runtime.RuntimeInstanceConfig;
import org.apache.eventmesh.runtime.boot.RuntimeInstance;
import org.apache.eventmesh.runtime.util.BannerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeInstanceStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuntimeInstanceStarter.class);

    public static void main(String[] args) {
        try {
            RuntimeInstanceConfig runtimeInstanceConfig = (RuntimeInstanceConfig)ConfigService.getInstance().buildConfigInstance(RuntimeInstanceConfig.class);
            RuntimeInstance runtimeInstance = new RuntimeInstance(runtimeInstanceConfig);
            BannerUtil.generateBanner();
            runtimeInstance.init();
            runtimeInstance.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    log.info("runtime shutting down hook begin.");
                    long start = System.currentTimeMillis();
                    runtimeInstance.shutdown();
                    long end = System.currentTimeMillis();
                    log.info("runtime shutdown cost {}ms", (Object)(end - start));
                }
                catch (Exception e) {
                    log.error("exception when shutdown {}", (Object)e.getMessage(), (Object)e);
                }
            }));
        }
        catch (Throwable e) {
            log.error("runtime start fail {}.", (Object)e.getMessage(), (Object)e);
            System.exit(-1);
        }
    }
}

