/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.RedissonMultiLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.transaction.RedissonTransactionalReadLock;
import org.redisson.transaction.RedissonTransactionalWriteLock;

public class BaseTransactionalObject {
    final String transactionId;
    final String lockName;
    final CommandAsyncExecutor commandExecutor;

    public BaseTransactionalObject(String transactionId, String lockName, CommandAsyncExecutor commandExecutor) {
        this.transactionId = transactionId;
        this.lockName = lockName;
        this.commandExecutor = commandExecutor;
    }

    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("move method is not supported in transaction");
    }

    public RFuture<Void> migrateAsync(String host, int port, int database) {
        throw new UnsupportedOperationException("migrate method is not supported in transaction");
    }

    protected RLock getWriteLock() {
        return new RedissonTransactionalWriteLock(this.commandExecutor, this.lockName, this.transactionId);
    }

    protected RLock getReadLock() {
        return new RedissonTransactionalReadLock(this.commandExecutor, this.lockName, this.transactionId);
    }

    protected static String getLockName(String name) {
        return name + ":transaction_lock";
    }

    protected <R> RFuture<R> executeLocked(long timeout, Supplier<CompletionStage<R>> runnable, RLock lock) {
        return this.executeLocked(Thread.currentThread().getId(), timeout, runnable, lock);
    }

    protected <R> RFuture<R> executeLocked(long threadId, long timeout, Supplier<CompletionStage<R>> runnable, RLock lock) {
        CompletionStage f = lock.lockAsync(timeout, TimeUnit.MILLISECONDS, threadId).thenCompose(res -> (CompletionStage)runnable.get());
        return new CompletableFutureWrapper(f);
    }

    protected <R> RFuture<R> executeLocked(long timeout, Supplier<CompletionStage<R>> runnable, List<RLock> locks) {
        RedissonMultiLock multiLock = new RedissonMultiLock(locks.toArray(new RLock[0]));
        long threadId = Thread.currentThread().getId();
        CompletionStage<Object> f = multiLock.lockAsync(timeout, TimeUnit.MILLISECONDS).thenCompose(res -> (CompletionStage)runnable.get()).whenComplete((r, e) -> {
            if (e != null) {
                multiLock.unlockAsync(threadId);
            }
        });
        return new CompletableFutureWrapper<Object>(f);
    }
}

