/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.grpc;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.eventmesh.common.Pair;
import org.apache.eventmesh.metrics.api.model.DoubleHistogramMetric;
import org.apache.eventmesh.metrics.api.model.InstrumentFurther;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.NoopDoubleHistogram;
import org.apache.eventmesh.metrics.api.model.ObservableDoubleGaugeMetric;
import org.apache.eventmesh.metrics.api.model.ObservableLongGaugeMetric;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;

public class GrpcMetrics {
    private static final String GRPC_METRICS_NAME_PREFIX = "eventmesh.grpc.";
    private static final String METRIC_NAME = "GRPC";
    private static double ms = 1.0;
    private static double s = 1000.0 * ms;
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final AtomicLong client2EventMeshMsgNum;
    private final AtomicLong eventMesh2MqMsgNum;
    private final AtomicLong mq2EventMeshMsgNum;
    private final AtomicLong eventMesh2ClientMsgNum;
    private volatile double client2EventMeshTPS;
    private volatile double eventMesh2ClientTPS;
    private volatile double eventMesh2MqTPS;
    private volatile double mq2EventMeshTPS;
    private volatile long retrySize;
    private volatile long subscribeTopicNum;
    private final DoubleHistogram grpcPublishHandleCost = new NoopDoubleHistogram();
    private ObservableDoubleGaugeMetric mq2eventMeshTPSGauge;
    private ObservableDoubleGaugeMetric client2eventMeshTPSGauge;
    private ObservableDoubleGaugeMetric eventMesh2clientTPSGauge;
    private ObservableDoubleGaugeMetric eventMesh2mqTPSGauge;
    private ObservableLongGaugeMetric subTopicGauge;
    private DoubleHistogramMetric grpcPublishHandleCostHistogram;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>(32);
    private final Map<String, String> labelMap;

    public GrpcMetrics(EventMeshGrpcServer eventMeshGrpcServer, Map<String, String> labelMap) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.labelMap = labelMap;
        this.client2EventMeshMsgNum = new AtomicLong(0L);
        this.eventMesh2MqMsgNum = new AtomicLong(0L);
        this.mq2EventMeshMsgNum = new AtomicLong(0L);
        this.eventMesh2ClientMsgNum = new AtomicLong(0L);
        this.initMetric();
    }

    private void initMetric() {
        HashMap<String, String> commonAttributes = new HashMap<String, String>(this.labelMap);
        InstrumentFurther furtherTopic = new InstrumentFurther();
        furtherTopic.setUnit("1");
        furtherTopic.setDescription("Number of grpc client subscribe for topic");
        furtherTopic.setName("eventmesh.grpc.sub.topic.num");
        this.subTopicGauge = new ObservableLongGaugeMetric(furtherTopic, METRIC_NAME, this.buildSubTopicSupplier());
        this.subTopicGauge.putAll(commonAttributes);
        this.metrics.put("subTopicGauge", (Metric)this.subTopicGauge);
        InstrumentFurther furtherCl2Em = new InstrumentFurther();
        furtherCl2Em.setUnit("tps");
        furtherCl2Em.setDescription("Tps of client to EventMesh.");
        furtherCl2Em.setName("eventmesh.grpc.client.eventmesh.tps");
        this.client2eventMeshTPSGauge = new ObservableDoubleGaugeMetric(furtherCl2Em, METRIC_NAME, () -> this.client2EventMeshTPS);
        this.client2eventMeshTPSGauge.putAll(commonAttributes);
        this.metrics.put("client2eventMeshTPSGauge", (Metric)this.client2eventMeshTPSGauge);
        InstrumentFurther furtherEm2Cl = new InstrumentFurther();
        furtherEm2Cl.setUnit("tps");
        furtherEm2Cl.setDescription("Tps of EventMesh to client.");
        furtherEm2Cl.setName("eventmesh.grpc.eventmesh.client.tps");
        this.eventMesh2clientTPSGauge = new ObservableDoubleGaugeMetric(furtherEm2Cl, METRIC_NAME, () -> this.eventMesh2ClientTPS);
        this.eventMesh2clientTPSGauge.putAll(commonAttributes);
        this.metrics.put("eventMesh2clientTPSGauge", (Metric)this.eventMesh2clientTPSGauge);
        InstrumentFurther furtherEm2Mq = new InstrumentFurther();
        furtherEm2Mq.setUnit("tps");
        furtherEm2Mq.setDescription("Tps of EventMesh to MQ.");
        furtherEm2Mq.setName("eventmesh.grpc.eventmesh.mq.tps");
        this.eventMesh2mqTPSGauge = new ObservableDoubleGaugeMetric(furtherEm2Mq, METRIC_NAME, () -> this.eventMesh2MqTPS);
        this.eventMesh2mqTPSGauge.putAll(commonAttributes);
        this.metrics.put("eventMesh2mqTPSGauge", (Metric)this.eventMesh2mqTPSGauge);
        InstrumentFurther furtherMq2Em = new InstrumentFurther();
        furtherMq2Em.setUnit("tps");
        furtherMq2Em.setDescription("Tps of MQ to EventMesh.");
        furtherMq2Em.setName("eventmesh.grpc.mq.eventmesh.tps");
        this.mq2eventMeshTPSGauge = new ObservableDoubleGaugeMetric(furtherMq2Em, METRIC_NAME, () -> this.mq2EventMeshTPS);
        this.mq2eventMeshTPSGauge.putAll(commonAttributes);
        this.metrics.put("mq2eventMeshTPSGauge", (Metric)this.mq2eventMeshTPSGauge);
        InstrumentFurther furtherGrpcPublishHandleCost = new InstrumentFurther();
        furtherGrpcPublishHandleCost.setUnit("ms");
        furtherGrpcPublishHandleCost.setDescription("Grpc publish handle cost time");
        String grpcPublishHandleCostName = "eventmesh.grpc.publish.handle.cost";
        furtherGrpcPublishHandleCost.setName(grpcPublishHandleCostName);
        Pair<InstrumentSelector, View> pair = this.buildGrpcPublishHandleCostMetricsView(grpcPublishHandleCostName);
        furtherGrpcPublishHandleCost.putExt("instrument_view", pair);
        this.grpcPublishHandleCostHistogram = new DoubleHistogramMetric(furtherGrpcPublishHandleCost, METRIC_NAME);
        this.metrics.put("grpcPublishHandleCost", (Metric)this.grpcPublishHandleCostHistogram);
    }

    private Pair<InstrumentSelector, View> buildGrpcPublishHandleCostMetricsView(String metricName) {
        List<Double> latencyBuckets = Arrays.asList(1.0 * ms, 3.0 * ms, 5.0 * ms, 10.0 * ms, 30.0 * ms, 50.0 * ms, 100.0 * ms, 300.0 * ms, 500.0 * ms, 1.0 * s, 3.0 * s, 5.0 * s, 10.0 * s);
        View view = View.builder().setAggregation(Aggregation.explicitBucketHistogram(latencyBuckets)).build();
        InstrumentSelector selector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(metricName).build();
        return new Pair((Object)selector, (Object)view);
    }

    public void recordGrpcPublishHandleCost(long time, Attributes attributes) {
        this.grpcPublishHandleCostHistogram.getInstrument().record((double)time, attributes);
    }

    private Supplier<Long> buildSubTopicSupplier() {
        return () -> this.eventMeshGrpcServer.getConsumerManager().getAllConsumerTopic().size();
    }

    public void clearAllMessageCounter() {
        this.client2EventMeshMsgNum.set(0L);
        this.eventMesh2MqMsgNum.set(0L);
        this.mq2EventMeshMsgNum.set(0L);
        this.eventMesh2ClientMsgNum.set(0L);
    }

    public void refreshTpsMetrics(long intervalMills) {
        BigDecimal intervalMillisBD = BigDecimal.valueOf(intervalMills);
        this.client2EventMeshTPS = BigDecimal.valueOf(1000L).multiply(BigDecimal.valueOf(this.client2EventMeshMsgNum.get())).divide(intervalMillisBD, 2, RoundingMode.HALF_UP).doubleValue();
        this.eventMesh2ClientTPS = BigDecimal.valueOf(1000L).multiply(BigDecimal.valueOf(this.eventMesh2ClientMsgNum.get())).divide(intervalMillisBD, 2, RoundingMode.HALF_UP).doubleValue();
        this.eventMesh2MqTPS = BigDecimal.valueOf(1000L).multiply(BigDecimal.valueOf(this.eventMesh2MqMsgNum.get())).divide(intervalMillisBD, 2, RoundingMode.HALF_UP).doubleValue();
        this.mq2EventMeshTPS = BigDecimal.valueOf(1000L).multiply(BigDecimal.valueOf(this.mq2EventMeshMsgNum.get())).divide(intervalMillisBD, 2, RoundingMode.HALF_UP).doubleValue();
    }

    public Collection<Metric> getMetrics() {
        return this.metrics.values();
    }

    public AtomicLong getClient2EventMeshMsgNum() {
        return this.client2EventMeshMsgNum;
    }

    public AtomicLong getEventMesh2MqMsgNum() {
        return this.eventMesh2MqMsgNum;
    }

    public AtomicLong getMq2EventMeshMsgNum() {
        return this.mq2EventMeshMsgNum;
    }

    public AtomicLong getEventMesh2ClientMsgNum() {
        return this.eventMesh2ClientMsgNum;
    }

    public double getClient2EventMeshTPS() {
        return this.client2EventMeshTPS;
    }

    public double getEventMesh2ClientTPS() {
        return this.eventMesh2ClientTPS;
    }

    public double getEventMesh2MqTPS() {
        return this.eventMesh2MqTPS;
    }

    public double getMq2EventMeshTPS() {
        return this.mq2EventMeshTPS;
    }

    public long getRetrySize() {
        return this.retrySize;
    }

    public void setRetrySize(long retrySize) {
        this.retrySize = retrySize;
    }

    public long getSubscribeTopicNum() {
        return this.subscribeTopicNum;
    }

    public void setSubscribeTopicNum(long subscribeTopicNum) {
        this.subscribeTopicNum = subscribeTopicNum;
    }
}

