/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.group;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupMetadata;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicMetadata;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.dispatch.DownstreamDispatchStrategy;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.dispatch.FreePriorityDispatchStrategy;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionGroupMapping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientSessionGroupMapping.class);
    private static final Logger SESSION_LOGGER = LoggerFactory.getLogger((String)"sessionLogger");
    private final ConcurrentHashMap<InetSocketAddress, Session> sessionTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ClientGroupWrapper> clientGroupMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> lockMap = new ConcurrentHashMap();
    private EventMeshTCPServer eventMeshTCPServer;

    public ClientSessionGroupMapping(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public void setEventMeshTCPServer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public ClientGroupWrapper getClientGroupWrapper(String sysId) {
        return (ClientGroupWrapper)MapUtils.getObject(this.clientGroupMap, (Object)sysId, null);
    }

    public Session getSession(ChannelHandlerContext ctx) {
        return this.getSession((InetSocketAddress)ctx.channel().remoteAddress());
    }

    public Session getSession(InetSocketAddress address) {
        return this.sessionTable.get(address);
    }

    public Session createSession(UserAgent user, ChannelHandlerContext ctx) throws Exception {
        Session session;
        InetSocketAddress addr = (InetSocketAddress)ctx.channel().remoteAddress();
        user.setHost(addr.getHostString());
        user.setPort(addr.getPort());
        if (!this.sessionTable.containsKey(addr)) {
            log.info("createSession client[{}]", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
            session = new Session(user, ctx, this.eventMeshTCPServer.getEventMeshTCPConfiguration());
            this.initClientGroupWrapper(user, session);
            this.sessionTable.put(addr, session);
            SESSION_LOGGER.info("session|open|succeed|user={}", (Object)user);
        } else {
            session = this.sessionTable.get(addr);
            SESSION_LOGGER.error("session|open|failed|user={}|msg={}", (Object)user, (Object)"session has been created!");
        }
        return session;
    }

    public void readySession(Session session) throws Exception {
        if (!"sub".equals(session.getClient().getPurpose())) {
            throw new Exception("client purpose config is not sub");
        }
        this.startClientGroupConsumer(session);
    }

    public synchronized void closeSession(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress addr = (InetSocketAddress)ctx.channel().remoteAddress();
        Session session = (Session)MapUtils.getObject(this.sessionTable, (Object)addr, null);
        if (session == null) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("begin to close channel to remote address[{}]", (Object)remoteAddress);
            ctx.channel().close().addListener((GenericFutureListener)((ChannelFutureListener)future -> log.info("close the connection to remote address[{}] result: {}", (Object)remoteAddress, (Object)future.isSuccess())));
            SESSION_LOGGER.info("session|close|succeed|address={}|msg={}", (Object)addr, (Object)"no session was found");
            return;
        }
        this.closeSession(session);
        this.sessionTable.remove(addr);
        SESSION_LOGGER.info("session|close|succeed|user={}", (Object)session.getClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(Session session) throws Exception {
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(session.getContext().channel());
        if (SessionState.CLOSED == session.getSessionState()) {
            log.info("session has been closed, addr:{}", (Object)remoteAddress);
            return;
        }
        Session session2 = session;
        synchronized (session2) {
            if (SessionState.CLOSED == session.getSessionState()) {
                log.info("session has been closed in sync, addr:{}", (Object)remoteAddress);
                return;
            }
            session.setSessionState(SessionState.CLOSED);
            String clientGroup = session.getClient().getGroup();
            if (!this.lockMap.containsKey(clientGroup)) {
                this.lockMap.putIfAbsent(clientGroup, new Object());
            }
            Object object = this.lockMap.get(clientGroup);
            synchronized (object) {
                if ("sub".equals(session.getClient().getPurpose())) {
                    this.cleanClientGroupWrapperByCloseSub(session);
                } else if ("pub".equals(session.getClient().getPurpose())) {
                    this.cleanClientGroupWrapperByClosePub(session);
                } else {
                    log.error("client purpose config is error:{}", (Object)session.getClient().getPurpose());
                }
            }
            if (session.getContext() != null) {
                log.info("begin to close channel to remote address[{}]", (Object)remoteAddress);
                session.getContext().channel().close().addListener((GenericFutureListener)((ChannelFutureListener)future -> log.info("close the connection to remote address[{}] result: {}", (Object)remoteAddress, (Object)future.isSuccess())));
            }
        }
    }

    private ClientGroupWrapper constructClientGroupWrapper(String sysId, String group, EventMeshTCPServer eventMeshTCPServer, DownstreamDispatchStrategy downstreamDispatchStrategy) {
        return new ClientGroupWrapper(sysId, group, eventMeshTCPServer, downstreamDispatchStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClientGroupWrapper(UserAgent user, Session session) throws Exception {
        Object obj;
        if (!this.lockMap.containsKey(user.getGroup()) && (obj = this.lockMap.putIfAbsent(user.getGroup(), new Object())) == null) {
            log.info("add lock to map for group:{}", (Object)user.getGroup());
        }
        Object object = this.lockMap.get(user.getGroup());
        synchronized (object) {
            ClientGroupWrapper cgw;
            if (!this.clientGroupMap.containsKey(user.getGroup())) {
                cgw = this.constructClientGroupWrapper(user.getSubsystem(), user.getGroup(), this.eventMeshTCPServer, new FreePriorityDispatchStrategy());
                this.clientGroupMap.put(user.getGroup(), cgw);
                log.info("create new ClientGroupWrapper, group:{}", (Object)user.getGroup());
            }
            cgw = this.clientGroupMap.get(user.getGroup());
            if ("pub".equals(user.getPurpose())) {
                this.startClientGroupProducer(cgw, session);
            } else if ("sub".equals(user.getPurpose())) {
                this.initClientGroupConsumser(cgw);
            } else {
                log.error("unknown client purpose:{}", (Object)user.getPurpose());
                throw new Exception("client purpose config is error");
            }
            session.setClientGroupWrapper(new WeakReference<ClientGroupWrapper>(cgw));
        }
    }

    private void startClientGroupProducer(ClientGroupWrapper cgw, Session session) throws Exception {
        boolean flag;
        if (!cgw.getProducerStarted().get()) {
            cgw.startClientGroupProducer();
        }
        if (!(flag = cgw.addGroupProducerSession(session))) {
            throw new Exception("addGroupProducerSession fail");
        }
        session.setSessionState(SessionState.RUNNING);
    }

    private void initClientGroupConsumser(ClientGroupWrapper cgw) throws Exception {
        if (!cgw.getProducerStarted().get()) {
            cgw.startClientGroupProducer();
        }
        if (!cgw.getInited4Broadcast().get()) {
            cgw.initClientGroupBroadcastConsumer();
        }
        if (!cgw.getInited4Persistent().get()) {
            cgw.initClientGroupPersistentConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startClientGroupConsumer(Session session) throws Exception {
        String subsystem = session.getClient().getSubsystem();
        if (!this.lockMap.containsKey(subsystem)) {
            this.lockMap.putIfAbsent(subsystem, new Object());
        }
        Object object = this.lockMap.get(subsystem);
        synchronized (object) {
            boolean flag;
            log.info("readySession session[{}]", (Object)session);
            ClientGroupWrapper cgw = (ClientGroupWrapper)session.getClientGroupWrapper().get();
            boolean bl = flag = cgw != null && cgw.addGroupConsumerSession(session);
            if (!flag) {
                throw new Exception("addGroupConsumerSession fail");
            }
            if (cgw.getInited4Persistent().get() && !cgw.getStarted4Persistent().get()) {
                cgw.startClientGroupPersistentConsumer();
            }
            if (cgw.getInited4Broadcast().get() && !cgw.getStarted4Broadcast().get()) {
                cgw.startClientGroupBroadcastConsumer();
            }
            session.setSessionState(SessionState.RUNNING);
        }
    }

    private void cleanClientGroupWrapperByCloseSub(Session session) throws Exception {
        this.cleanSubscriptionInSession(session);
        ClientGroupWrapper clientGroupWrapper = (ClientGroupWrapper)Objects.requireNonNull(session.getClientGroupWrapper().get());
        clientGroupWrapper.removeGroupConsumerSession(session);
        this.handleUnackMsgsInSession(session);
        this.cleanClientGroupWrapperCommon(clientGroupWrapper);
    }

    private void cleanClientGroupWrapperByClosePub(Session session) throws Exception {
        ClientGroupWrapper clientGroupWrapper = (ClientGroupWrapper)Objects.requireNonNull(session.getClientGroupWrapper().get());
        clientGroupWrapper.removeGroupProducerSession(session);
        this.cleanClientGroupWrapperCommon(clientGroupWrapper);
    }

    private void cleanSubscriptionInSession(Session session) throws Exception {
        for (SubscriptionItem item : session.getSessionContext().getSubscribeTopics().values()) {
            ClientGroupWrapper clientGroupWrapper = (ClientGroupWrapper)Objects.requireNonNull(session.getClientGroupWrapper().get());
            clientGroupWrapper.removeSubscription(item, session);
            if (clientGroupWrapper.hasSubscription(item.getTopic())) continue;
            clientGroupWrapper.unsubscribe(item);
        }
    }

    private void handleUnackMsgsInSession(Session session) {
        ConcurrentHashMap<String, DownStreamMsgContext> unAckMsg = session.getPusher().getUnAckMsg();
        ClientGroupWrapper clientGroupWrapper = (ClientGroupWrapper)Objects.requireNonNull(session.getClientGroupWrapper().get());
        if (unAckMsg.size() > 0 && !clientGroupWrapper.getGroupConsumerSessions().isEmpty()) {
            for (Map.Entry<String, DownStreamMsgContext> entry : unAckMsg.entrySet()) {
                DownStreamMsgContext downStreamMsgContext = entry.getValue();
                if (SubscriptionMode.BROADCASTING == downStreamMsgContext.getSubscriptionItem().getMode()) {
                    log.warn("exist broadcast msg unack when closeSession,seq:{},bizSeq:{},client:{}", new Object[]{downStreamMsgContext.seq, EventMeshUtil.getMessageBizSeq(downStreamMsgContext.event), session.getClient()});
                    continue;
                }
                Session reChooseSession = clientGroupWrapper.getDownstreamDispatchStrategy().select(clientGroupWrapper.getGroup(), downStreamMsgContext.event.getSubject(), clientGroupWrapper.getGroupConsumerSessions());
                if (reChooseSession != null) {
                    downStreamMsgContext.setSession(reChooseSession);
                    reChooseSession.getPusher().unAckMsg(downStreamMsgContext.seq, downStreamMsgContext);
                    reChooseSession.downstreamMsg(downStreamMsgContext);
                    log.info("rePush msg form unAckMsgs,seq:{},rePushClient:{}", (Object)entry.getKey(), (Object)downStreamMsgContext.getSession().getClient());
                    continue;
                }
                log.warn("select session fail in handleUnackMsgsInSession,seq:{},topic:{}", (Object)entry.getKey(), (Object)downStreamMsgContext.event.getSubject());
            }
        }
    }

    private void cleanClientGroupWrapperCommon(ClientGroupWrapper clientGroupWrapper) throws Exception {
        if (CollectionUtils.isEmpty(clientGroupWrapper.getGroupConsumerSessions())) {
            this.shutdownClientGroupConsumer(clientGroupWrapper);
        }
        log.info("GroupProducerSessions size:{}", (Object)clientGroupWrapper.getGroupProducerSessions().size());
        if (CollectionUtils.isEmpty(clientGroupWrapper.getGroupConsumerSessions()) && CollectionUtils.isEmpty(clientGroupWrapper.getGroupProducerSessions())) {
            this.shutdownClientGroupProducer(clientGroupWrapper);
            this.clientGroupMap.remove(clientGroupWrapper.getGroup());
            this.lockMap.remove(clientGroupWrapper.getGroup());
            log.info("remove clientGroupWrapper group[{}]", (Object)clientGroupWrapper.getGroup());
        }
    }

    private void shutdownClientGroupConsumer(ClientGroupWrapper clientGroupWrapper) throws Exception {
        if (clientGroupWrapper.getStarted4Broadcast().get()) {
            clientGroupWrapper.shutdownBroadCastConsumer();
        }
        if (clientGroupWrapper.getStarted4Persistent().get()) {
            clientGroupWrapper.shutdownPersistentConsumer();
        }
    }

    private void shutdownClientGroupProducer(ClientGroupWrapper clientGroupWrapper) throws Exception {
        if (clientGroupWrapper.getProducerStarted().get()) {
            clientGroupWrapper.shutdownProducer();
        }
    }

    private void initSessionCleaner() {
        this.eventMeshTCPServer.getTcpThreadPoolGroup().getScheduler().scheduleAtFixedRate(() -> {
            for (Session tmp : this.sessionTable.values()) {
                long interval = System.currentTimeMillis() - tmp.getLastHeartbeatTime();
                if (interval <= (long)this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpSessionExpiredInMills()) continue;
                try {
                    log.warn("clean expired session,client:{}", (Object)tmp.getClient());
                    this.closeSession(tmp.getContext());
                }
                catch (Exception e) {
                    log.error("say goodbye to session error! {}", (Object)tmp, (Object)e);
                }
            }
        }, 1000L, this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpSessionExpiredInMills(), TimeUnit.MILLISECONDS);
    }

    private void initDownStreamMsgContextCleaner() {
        this.eventMeshTCPServer.getTcpThreadPoolGroup().getScheduler().scheduleAtFixedRate(() -> {
            for (Session tmp : this.sessionTable.values()) {
                for (Map.Entry<String, DownStreamMsgContext> entry : tmp.getPusher().getUnAckMsg().entrySet()) {
                    String seqKey = entry.getKey();
                    DownStreamMsgContext downStreamMsgContext = entry.getValue();
                    if (!downStreamMsgContext.isExpire()) continue;
                    downStreamMsgContext.ackMsg();
                    tmp.getPusher().getUnAckMsg().remove(seqKey);
                    log.warn("remove expire downStreamMsgContext, session:{}, topic:{}, seq:{}", new Object[]{tmp, downStreamMsgContext.event.getSubject(), seqKey});
                }
            }
        }, 1000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public void init() throws Exception {
        this.initSessionCleaner();
        this.initDownStreamMsgContextCleaner();
        log.info("ClientSessionGroupMapping inited......");
    }

    public void start() throws Exception {
        log.info("ClientSessionGroupMapping started......");
    }

    public void shutdown() throws Exception {
        log.info("begin to close sessions gracefully");
        for (ClientGroupWrapper clientGroupWrapper : this.clientGroupMap.values()) {
            for (Session subSession : clientGroupWrapper.getGroupConsumerSessions()) {
                try {
                    EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer.getTcpThreadPoolGroup(), subSession, this);
                }
                catch (Exception e) {
                    log.error("say goodbye to subSession error! {}", (Object)subSession, (Object)e);
                }
            }
            for (Session pubSession : clientGroupWrapper.getGroupProducerSessions()) {
                try {
                    EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer.getTcpThreadPoolGroup(), pubSession, this);
                }
                catch (Exception e) {
                    log.error("say goodbye to pubSession error! {}", (Object)pubSession, (Object)e);
                }
            }
            ThreadUtils.sleep((long)this.eventMeshTCPServer.getEventMeshTCPConfiguration().getGracefulShutdownSleepIntervalInMills(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        ThreadUtils.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.sessionTable.values().parallelStream().forEach(itr -> {
            try {
                EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer.getTcpThreadPoolGroup(), itr, this);
            }
            catch (Exception e) {
                log.error("say goodbye to session error! {}", itr, (Object)e);
            }
        });
        ThreadUtils.randomPause((long)50L);
        log.info("ClientSessionGroupMapping shutdown......");
    }

    public ConcurrentHashMap<InetSocketAddress, Session> getSessionMap() {
        return this.sessionTable;
    }

    public ConcurrentHashMap<String, ClientGroupWrapper> getClientGroupMap() {
        return this.clientGroupMap;
    }

    public Map<String, Map<String, Integer>> prepareEventMeshClientDistributionData() {
        HashMap result = null;
        if (!this.clientGroupMap.isEmpty()) {
            result = new HashMap();
            for (Map.Entry<String, ClientGroupWrapper> entry : this.clientGroupMap.entrySet()) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("sub", entry.getValue().getGroupConsumerSessions().size());
                map.put("pub", entry.getValue().getGroupProducerSessions().size());
                result.put(entry.getKey(), map);
            }
        }
        return result;
    }

    public Map<String, Map<String, Integer>> prepareProxyClientDistributionData() {
        HashMap result = null;
        if (!this.clientGroupMap.isEmpty()) {
            result = new HashMap();
            for (Map.Entry<String, ClientGroupWrapper> entry : this.clientGroupMap.entrySet()) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("sub", entry.getValue().getGroupConsumerSessions().size());
                map.put("pub", entry.getValue().getGroupProducerSessions().size());
                result.put(entry.getKey(), map);
            }
        }
        return result;
    }

    public void updateMetaData() {
        if (!this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerMetaStorageEnable()) {
            return;
        }
        try {
            HashMap<String, String> metadata = new HashMap<String, String>(16);
            for (Map.Entry<String, ClientGroupWrapper> clientGroupWrapperMap : this.clientGroupMap.entrySet()) {
                String group = clientGroupWrapperMap.getKey();
                ClientGroupWrapper cgw = clientGroupWrapperMap.getValue();
                ConsumerGroupMetadata consumerGroupMetadata = new ConsumerGroupMetadata();
                consumerGroupMetadata.setConsumerGroup(group);
                HashMap<String, ConsumerGroupTopicMetadata> consumerGroupTopicMetadataMap = new HashMap<String, ConsumerGroupTopicMetadata>(16);
                ConcurrentHashMap<String, Map<String, Session>> topic2sessionInGroupMapping = cgw.getTopic2sessionInGroupMapping();
                for (Map.Entry topicSessionMap : topic2sessionInGroupMapping.entrySet()) {
                    String topic = (String)topicSessionMap.getKey();
                    Map sessionMap = (Map)topicSessionMap.getValue();
                    ConsumerGroupTopicMetadata consumerGroupTopicMetadata = new ConsumerGroupTopicMetadata();
                    consumerGroupTopicMetadata.setConsumerGroup(group);
                    consumerGroupTopicMetadata.setTopic(topic);
                    HashSet<String> sessionSet = new HashSet<String>();
                    for (Map.Entry sessionEntry : sessionMap.entrySet()) {
                        String sessionId = (String)sessionEntry.getKey();
                        Session session = (Session)sessionEntry.getValue();
                        sessionSet.add(session.toString());
                    }
                    consumerGroupTopicMetadata.setUrls(sessionSet);
                    consumerGroupTopicMetadataMap.put(topic, consumerGroupTopicMetadata);
                }
                consumerGroupMetadata.setConsumerGroupTopicMetadataMap(consumerGroupTopicMetadataMap);
                metadata.put(group, JsonUtils.toJSONString((Object)consumerGroupMetadata));
            }
            metadata.put("protocol", "tcp");
            this.eventMeshTCPServer.getMetaStorage().updateMetaData(metadata);
        }
        catch (Exception e) {
            log.error("update eventmesh metadata error", (Throwable)e);
        }
    }
}

