/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.service;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.PublisherServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.BatchPublishCloudEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.PublishCloudEventsProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.RequestCloudEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherService
extends PublisherServiceGrpc.PublisherServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublisherService.class);
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final ThreadPoolExecutor threadPoolExecutor;

    public PublisherService(EventMeshGrpcServer eventMeshGrpcServer, ThreadPoolExecutor threadPoolExecutor) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void publish(CloudEvent request, StreamObserver<CloudEvent> responseObserver) {
        String clientId = EventMeshCloudEventUtils.getIp((CloudEvent)request);
        log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"publish", "grpc", EventMeshCloudEventUtils.getIp((CloudEvent)request), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshIp()});
        this.eventMeshGrpcServer.getEventMeshGrpcMetricsManager().recordReceiveMsgFromClient(clientId);
        EventEmitter<CloudEvent> emitter = new EventEmitter<CloudEvent>(responseObserver);
        this.threadPoolExecutor.submit(() -> {
            PublishCloudEventsProcessor publishCloudEventsProcessor = new PublishCloudEventsProcessor(this.eventMeshGrpcServer);
            try {
                publishCloudEventsProcessor.process(request, emitter);
            }
            catch (Exception e) {
                log.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode(), StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg(), e});
                ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_SEND_ASYNC_MSG_ERR, e.getMessage(), emitter);
            }
        });
    }

    public void requestReply(CloudEvent request, StreamObserver<CloudEvent> responseObserver) {
        String clientIp = EventMeshCloudEventUtils.getIp((CloudEvent)request);
        log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"RequestReply", "grpc", EventMeshCloudEventUtils.getIp((CloudEvent)request), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshIp()});
        this.eventMeshGrpcServer.getEventMeshGrpcMetricsManager().recordReceiveMsgFromClient(clientIp);
        EventEmitter<CloudEvent> emitter = new EventEmitter<CloudEvent>(responseObserver);
        this.threadPoolExecutor.submit(() -> {
            RequestCloudEventProcessor requestMessageProcessor = new RequestCloudEventProcessor(this.eventMeshGrpcServer);
            try {
                requestMessageProcessor.process(request, emitter);
            }
            catch (Exception e) {
                log.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR.getRetCode(), StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR.getErrMsg(), e});
                ServiceUtils.sendStreamResponseCompleted(request, StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR, e.getMessage(), emitter);
            }
        });
    }

    public void batchPublish(CloudEventBatch request, StreamObserver<CloudEvent> responseObserver) {
        String clientIp = EventMeshCloudEventUtils.getIp((CloudEvent)request.getEvents(0));
        log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{"BatchPublish", "grpc", null, this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshIp()});
        this.eventMeshGrpcServer.getEventMeshGrpcMetricsManager().recordReceiveMsgFromClient(request.getEventsCount(), clientIp);
        EventEmitter<CloudEvent> emitter = new EventEmitter<CloudEvent>(responseObserver);
        this.threadPoolExecutor.submit(() -> {
            BatchPublishCloudEventProcessor batchPublishMessageProcessor = new BatchPublishCloudEventProcessor(this.eventMeshGrpcServer);
            try {
                batchPublishMessageProcessor.process(request, emitter);
            }
            catch (Exception e) {
                log.error("Error code {}, error message {}", new Object[]{StatusCode.EVENTMESH_BATCH_PUBLISH_ERR.getRetCode(), StatusCode.EVENTMESH_BATCH_PUBLISH_ERR.getErrMsg(), e});
                ServiceUtils.sendResponseCompleted(StatusCode.EVENTMESH_BATCH_PUBLISH_ERR, e.getMessage(), emitter);
            }
        });
    }
}

