/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.constants;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshVersion.class);
    private static String CURRENT_VERSION = "";
    private static final String VERSION_KEY = "Implementation-Version";
    private static final String SPEC_VERSION_KEY = "Specification-Version";
    private static final String VERSION_PATTERN = "version\\s*=\\s*['\"](.+)['\"]";

    public static String getCurrentVersionDesc() {
        if (StringUtils.isNotBlank((CharSequence)EventMeshVersion.getCurrentVersion())) {
            return "v" + CURRENT_VERSION;
        }
        return "";
    }

    public static String getCurrentVersion() {
        if (StringUtils.isNotBlank((CharSequence)CURRENT_VERSION)) {
            return CURRENT_VERSION;
        }
        EventMeshVersion.getVersionFromJarFile();
        if (StringUtils.isBlank((CharSequence)CURRENT_VERSION)) {
            EventMeshVersion.getVersionFromBuildFile();
        }
        return CURRENT_VERSION;
    }

    private static void getVersionFromJarFile() {
        CodeSource codeSource = EventMeshVersion.class.getProtectionDomain().getCodeSource();
        if (Objects.isNull(codeSource)) {
            log.warn("Failed to get CodeSource for EventMeshVersion.class");
            return;
        }
        URL url = codeSource.getLocation();
        if (Objects.isNull(url)) {
            log.warn("Failed to get URL for EventMeshVersion.class");
            return;
        }
        try (JarFile jarFile = new JarFile(url.getPath());){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = CURRENT_VERSION = StringUtils.isBlank((CharSequence)attributes.getValue(VERSION_KEY)) ? attributes.getValue(SPEC_VERSION_KEY) : attributes.getValue(VERSION_KEY);
            if (StringUtils.isBlank((CharSequence)CURRENT_VERSION)) {
                EventMeshVersion.getVersionFromJarFileName(url.getFile());
            }
        }
        catch (IOException e) {
            log.error("Failed to load project version from MANIFEST.MF due to IOException {}.", (Object)e.getMessage());
        }
    }

    private static void getVersionFromBuildFile() {
        String projectDir = System.getProperty("user.dir");
        String gradlePropertiesPath = projectDir + File.separator + "gradle.properties";
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(gradlePropertiesPath);){
            properties.load(fis);
            CURRENT_VERSION = properties.getProperty("version");
        }
        catch (IOException e) {
            log.error("Failed to load version from gradle.properties due to IOException {}.", (Object)e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)CURRENT_VERSION)) {
            String buildGradlePath = projectDir + File.separator + "build.gradle";
            try {
                File buildFile = new File(buildGradlePath);
                String content = new String(Files.readAllBytes(buildFile.toPath()));
                Pattern pattern = Pattern.compile(VERSION_PATTERN);
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    CURRENT_VERSION = matcher.group(1);
                } else {
                    log.warn("Failed to load version from build.gradle due to missing the configuration of \"version='xxx'\".");
                }
            }
            catch (IOException e) {
                log.error("Failed to load version from build.gradle due to IOException {}.", (Object)e.getMessage());
            }
        }
    }

    private static void getVersionFromJarFileName(String path) {
        if (!StringUtils.isEmpty((CharSequence)path) && path.endsWith(".jar")) {
            Path filePath = Paths.get(path, new String[0]);
            String fileName = filePath.getFileName().toString();
            fileName = fileName.replace(".jar", "");
            Pattern pattern = Pattern.compile("-\\d");
            Matcher matcher = pattern.matcher(fileName);
            if (matcher.find()) {
                int index = matcher.start();
                CURRENT_VERSION = fileName.substring(index + 1);
            } else {
                log.info("Failed to load version from jar name due to missing related info.");
            }
        }
    }
}

