/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.request.DeleteTCPClientRequest;
import org.apache.eventmesh.runtime.admin.response.v1.GetClientResponse;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/client/tcp")
public class TCPClientHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TCPClientHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public TCPClientHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    protected void delete(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        Map<String, Object> body = HttpRequestUtil.parseHttpRequestBody(httpRequest);
        Objects.requireNonNull(body, "body can not be null");
        DeleteTCPClientRequest deleteTCPClientRequest = (DeleteTCPClientRequest)JsonUtils.mapToObject(body, DeleteTCPClientRequest.class);
        String host = Objects.requireNonNull(deleteTCPClientRequest).getHost();
        int port = deleteTCPClientRequest.getPort();
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
        if (!sessionMap.isEmpty()) {
            for (Map.Entry<InetSocketAddress, Session> entry : sessionMap.entrySet()) {
                if (!entry.getKey().getHostString().equals(host) || entry.getKey().getPort() != port) continue;
                EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer.getTcpThreadPoolGroup(), entry.getValue(), clientSessionGroupMapping);
            }
        }
        this.writeText(ctx, "");
    }

    @Override
    protected void get(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
        ArrayList<GetClientResponse> getClientResponseList = new ArrayList<GetClientResponse>();
        for (Session session : sessionMap.values()) {
            UserAgent userAgent = session.getClient();
            GetClientResponse getClientResponse = new GetClientResponse(Optional.ofNullable(userAgent.getEnv()).orElse(""), Optional.ofNullable(userAgent.getSubsystem()).orElse(""), Optional.ofNullable(userAgent.getPath()).orElse(""), String.valueOf(userAgent.getPid()), Optional.ofNullable(userAgent.getHost()).orElse(""), userAgent.getPort(), Optional.ofNullable(userAgent.getVersion()).orElse(""), Optional.ofNullable(userAgent.getIdc()).orElse(""), Optional.ofNullable(userAgent.getGroup()).orElse(""), Optional.ofNullable(userAgent.getPurpose()).orElse(""), "TCP");
            getClientResponseList.add(getClientResponse);
        }
        getClientResponseList.sort((lhs, rhs) -> {
            if (lhs.getHost().equals(rhs.getHost())) {
                return lhs.getHost().compareTo(rhs.getHost());
            }
            return Integer.compare(rhs.getPort(), lhs.getPort());
        });
        String result = JsonUtils.toJSONString(getClientResponseList);
        this.writeJson(ctx, result);
    }
}

