/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/clientManage/showListenClientByTopic")
public class ShowListenClientByTopicHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShowListenClientByTopicHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public ShowListenClientByTopicHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        StringBuilder result = new StringBuilder();
        String queryString = URI.create(httpRequest.uri()).getQuery();
        Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
        String topic = (String)queryStringInfo.get("topic");
        String newLine = System.getProperty("line.separator");
        log.info("showListeningClientByTopic,topic:{}=================", (Object)topic);
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        ConcurrentHashMap<String, ClientGroupWrapper> clientGroupMap = clientSessionGroupMapping.getClientGroupMap();
        if (!clientGroupMap.isEmpty()) {
            for (ClientGroupWrapper cgw : clientGroupMap.values()) {
                Map<String, Session> listenSessions = cgw.getTopic2sessionInGroupMapping().get(topic);
                if (listenSessions == null || listenSessions.isEmpty()) continue;
                result.append(String.format("group:%s", cgw.getGroup())).append(newLine);
                for (Session session : listenSessions.values()) {
                    UserAgent userAgent = session.getClient();
                    result.append(String.format("pid=%s | ip=%s | port=%s | path=%s | version=%s", userAgent.getPid(), userAgent.getHost(), userAgent.getPort(), userAgent.getPath(), userAgent.getVersion())).append(newLine);
                }
            }
        }
        this.writeText(ctx, result.toString());
    }
}

