/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/clientManage/rejectClientByIpPort")
public class RejectClientByIpPortHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RejectClientByIpPortHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public RejectClientByIpPortHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        String result = "";
        String queryString = URI.create(httpRequest.uri()).getQuery();
        Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
        String ip = (String)queryStringInfo.get("ip");
        String port = (String)queryStringInfo.get("port");
        if (StringUtils.isBlank((CharSequence)ip) || StringUtils.isBlank((CharSequence)port)) {
            result = "params illegal!";
            this.writeText(ctx, result);
            return;
        }
        log.info("rejectClientByIpPort in admin,ip:{},port:{}====================", (Object)ip, (Object)port);
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
        ArrayList<InetSocketAddress> successRemoteAddrs = new ArrayList<InetSocketAddress>();
        try {
            if (!sessionMap.isEmpty()) {
                for (Map.Entry<InetSocketAddress, Session> entry : sessionMap.entrySet()) {
                    InetSocketAddress addr;
                    if (!entry.getKey().getHostString().equals(ip) || !String.valueOf(entry.getKey().getPort()).equals(port) || (addr = EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer.getTcpThreadPoolGroup(), entry.getValue(), clientSessionGroupMapping)) == null) continue;
                    successRemoteAddrs.add(addr);
                }
            }
        }
        catch (Exception e) {
            log.error("clientManage|rejectClientByIpPort|fail|ip={}|port={}", new Object[]{ip, port, e});
            result = String.format("rejectClientByIpPort fail! {ip=%s port=%s}, had reject {%s}, errorMsg : %s", ip, port, NetUtils.addressToString(successRemoteAddrs), e.getMessage());
            this.writeText(ctx, result);
            return;
        }
        result = String.format("rejectClientByIpPort success! {ip=%s port=%s}, had reject {%s}", ip, port, NetUtils.addressToString(successRemoteAddrs));
        this.writeText(ctx, result);
    }
}

