/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.provider.EventFormatProvider;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.plugin.MQAdminWrapper;
import org.apache.eventmesh.runtime.util.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/event")
public class EventHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventHandler.class);
    private final MQAdminWrapper admin;

    public EventHandler(String connectorPluginType) {
        this.admin = new MQAdminWrapper(connectorPluginType);
        try {
            this.admin.init(null);
        }
        catch (Exception ignored) {
            log.info("failed to initialize MQAdminWrapper");
        }
    }

    @Override
    protected void get(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add("Access-Control-Allow-Origin", (Object)"*");
        String queryString = URI.create(httpRequest.uri()).getQuery();
        if (queryString == null || queryString.isEmpty()) {
            this.writeUnauthorized(ctx, "");
            return;
        }
        Map<String, String> queryMap = HttpRequestUtil.queryStringToMap(queryString);
        String topicName = queryMap.get("topicName");
        int offset = Integer.parseInt(queryMap.get("offset"));
        int length = Integer.parseInt(queryMap.get("length"));
        List<CloudEvent> eventList = this.admin.getEvent(topicName, offset, length);
        ArrayList<String> eventJsonList = new ArrayList<String>();
        for (CloudEvent event : eventList) {
            byte[] serializedEvent = Objects.requireNonNull(EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json")).serialize(event);
            eventJsonList.add(new String(serializedEvent, StandardCharsets.UTF_8));
        }
        String result = JsonUtils.toJSONString(eventJsonList);
        this.writeJson(ctx, result);
    }

    @Override
    protected void post(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add("Access-Control-Allow-Origin", (Object)"*");
        String request = JsonUtils.toJSONString(HttpRequestUtil.parseHttpRequestBody(httpRequest));
        byte[] rawRequest = request.getBytes(StandardCharsets.UTF_8);
        CloudEvent event = Objects.requireNonNull(EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json")).deserialize(rawRequest);
        this.admin.publish(event);
        this.writeText(ctx, "");
    }
}

