/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.asm.optimizer;

import com.googlecode.aviator.asm.AnnotationVisitor;
import com.googlecode.aviator.asm.Attribute;
import com.googlecode.aviator.asm.ClassAdapter;
import com.googlecode.aviator.asm.ClassVisitor;
import com.googlecode.aviator.asm.FieldVisitor;
import com.googlecode.aviator.asm.MethodVisitor;
import com.googlecode.aviator.asm.optimizer.MethodOptimizer;
import com.googlecode.aviator.asm.optimizer.NameMapping;

public class ClassOptimizer
extends ClassAdapter {
    private NameMapping mapping;
    private String className;
    private String pkgName;

    public ClassOptimizer(ClassVisitor cv, NameMapping mapping) {
        super(cv);
        this.mapping = mapping;
    }

    public String getClassName() {
        return this.className;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.pkgName = name.substring(0, name.lastIndexOf(47));
        this.cv.visit(version, access, this.mapping.map(name), null, this.mapping.map(superName), interfaces);
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        throw new UnsupportedOperationException();
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        String s = this.className + "." + name;
        if ((access & 5) == 0) {
            if ((access & 0x10) != 0 && (access & 8) != 0 && desc.equals("I")) {
                return null;
            }
            if (this.pkgName.equals("org/objectweb/asm") && this.mapping.map(s).equals(name)) {
                System.out.println("INFO: " + s + " could be renamed");
            }
            this.cv.visitField(access, this.mapping.map(s), this.mapping.fix(desc), null, value);
        } else {
            if (!this.mapping.map(s).equals(name)) {
                throw new RuntimeException("The public or protected field " + s + " must not be renamed.");
            }
            this.cv.visitField(access, name, desc, null, value);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String s = this.className + "." + name + desc;
        if ((access & 5) == 0) {
            if (this.pkgName.equals("org/objectweb/asm") && !name.startsWith("<") && this.mapping.map(s).equals(name)) {
                System.out.println("INFO: " + s + " could be renamed");
            }
            return new MethodOptimizer(this.cv.visitMethod(access, this.mapping.map(s), this.mapping.fix(desc), null, exceptions), this.mapping);
        }
        if (!this.mapping.map(s).equals(name)) {
            throw new RuntimeException("The public or protected method " + s + " must not be renamed.");
        }
        return new MethodOptimizer(this.cv.visitMethod(access, name, desc, null, exceptions), this.mapping);
    }
}

