/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.tcp;

public enum Command {
    HEARTBEAT_REQUEST(0),
    HEARTBEAT_RESPONSE(1),
    HELLO_REQUEST(2),
    HELLO_RESPONSE(3),
    CLIENT_GOODBYE_REQUEST(4),
    CLIENT_GOODBYE_RESPONSE(5),
    SERVER_GOODBYE_REQUEST(6),
    SERVER_GOODBYE_RESPONSE(7),
    SUBSCRIBE_REQUEST(8),
    SUBSCRIBE_RESPONSE(9),
    UNSUBSCRIBE_REQUEST(10),
    UNSUBSCRIBE_RESPONSE(11),
    LISTEN_REQUEST(12),
    LISTEN_RESPONSE(13),
    REQUEST_TO_SERVER(14),
    REQUEST_TO_CLIENT(15),
    REQUEST_TO_CLIENT_ACK(16),
    RESPONSE_TO_SERVER(17),
    RESPONSE_TO_CLIENT(18),
    RESPONSE_TO_CLIENT_ACK(19),
    ASYNC_MESSAGE_TO_SERVER(20),
    ASYNC_MESSAGE_TO_SERVER_ACK(21),
    ASYNC_MESSAGE_TO_CLIENT(22),
    ASYNC_MESSAGE_TO_CLIENT_ACK(23),
    BROADCAST_MESSAGE_TO_SERVER(24),
    BROADCAST_MESSAGE_TO_SERVER_ACK(25),
    BROADCAST_MESSAGE_TO_CLIENT(26),
    BROADCAST_MESSAGE_TO_CLIENT_ACK(27),
    SYS_LOG_TO_LOGSERVER(28),
    TRACE_LOG_TO_LOGSERVER(29),
    REDIRECT_TO_CLIENT(30),
    REGISTER_REQUEST(31),
    REGISTER_RESPONSE(32),
    UNREGISTER_REQUEST(33),
    UNREGISTER_RESPONSE(34),
    RECOMMEND_REQUEST(35),
    RECOMMEND_RESPONSE(36);

    private final byte value;

    private Command(int value) {
        this.value = (byte)value;
    }

    public byte getValue() {
        return this.value;
    }

    public static Command valueOf(int value) {
        for (Command t : Command.values()) {
            if (t.value != value) continue;
            return t;
        }
        throw new IllegalArgumentException("No enum constant value=" + value);
    }
}

