/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.workplace.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.workplace.v1.model.SearchCustomWorkplaceAccessDataReq;
import com.lark.oapi.service.workplace.v1.model.SearchCustomWorkplaceAccessDataResp;
import com.lark.oapi.service.workplace.v1.model.SearchWorkplaceAccessDataReq;
import com.lark.oapi.service.workplace.v1.model.SearchWorkplaceAccessDataResp;
import com.lark.oapi.service.workplace.v1.model.SearchWorkplaceBlockAccessDataReq;
import com.lark.oapi.service.workplace.v1.model.SearchWorkplaceBlockAccessDataResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkplaceService {
    private static final Logger log = LoggerFactory.getLogger(WorkplaceService.class);
    private final CustomWorkplaceAccessData customWorkplaceAccessData;
    private final WorkplaceAccessData workplaceAccessData;
    private final WorkplaceBlockAccessData workplaceBlockAccessData;

    public WorkplaceService(Config config) {
        this.customWorkplaceAccessData = new CustomWorkplaceAccessData(config);
        this.workplaceAccessData = new WorkplaceAccessData(config);
        this.workplaceBlockAccessData = new WorkplaceBlockAccessData(config);
    }

    public CustomWorkplaceAccessData customWorkplaceAccessData() {
        return this.customWorkplaceAccessData;
    }

    public WorkplaceAccessData workplaceAccessData() {
        return this.workplaceAccessData;
    }

    public WorkplaceBlockAccessData workplaceBlockAccessData() {
        return this.workplaceBlockAccessData;
    }

    public static class WorkplaceBlockAccessData {
        private final Config config;

        public WorkplaceBlockAccessData(Config config) {
            this.config = config;
        }

        public SearchWorkplaceBlockAccessDataResp search(SearchWorkplaceBlockAccessDataReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SearchWorkplaceBlockAccessDataResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/workplace/v1/workplace_block_access_data/search", Sets.newHashSet(AccessTokenType.Tenant), req), SearchWorkplaceBlockAccessDataResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/workplace/v1/workplace_block_access_data/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchWorkplaceBlockAccessDataResp search(SearchWorkplaceBlockAccessDataReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/workplace/v1/workplace_block_access_data/search", Sets.newHashSet(AccessTokenType.Tenant), req);
            SearchWorkplaceBlockAccessDataResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchWorkplaceBlockAccessDataResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/workplace/v1/workplace_block_access_data/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class WorkplaceAccessData {
        private final Config config;

        public WorkplaceAccessData(Config config) {
            this.config = config;
        }

        public SearchWorkplaceAccessDataResp search(SearchWorkplaceAccessDataReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SearchWorkplaceAccessDataResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/workplace/v1/workplace_access_data/search", Sets.newHashSet(AccessTokenType.Tenant), req), SearchWorkplaceAccessDataResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/workplace/v1/workplace_access_data/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchWorkplaceAccessDataResp search(SearchWorkplaceAccessDataReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/workplace/v1/workplace_access_data/search", Sets.newHashSet(AccessTokenType.Tenant), req);
            SearchWorkplaceAccessDataResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchWorkplaceAccessDataResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/workplace/v1/workplace_access_data/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class CustomWorkplaceAccessData {
        private final Config config;

        public CustomWorkplaceAccessData(Config config) {
            this.config = config;
        }

        public SearchCustomWorkplaceAccessDataResp search(SearchCustomWorkplaceAccessDataReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SearchCustomWorkplaceAccessDataResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/workplace/v1/custom_workplace_access_data/search", Sets.newHashSet(AccessTokenType.Tenant), req), SearchCustomWorkplaceAccessDataResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/workplace/v1/custom_workplace_access_data/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchCustomWorkplaceAccessDataResp search(SearchCustomWorkplaceAccessDataReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/workplace/v1/custom_workplace_access_data/search", Sets.newHashSet(AccessTokenType.Tenant), req);
            SearchCustomWorkplaceAccessDataResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchCustomWorkplaceAccessDataResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/workplace/v1/custom_workplace_access_data/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

