/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.config.CommonConfiguration;

public class ConfigurationContextUtil {
    private static final ConcurrentHashMap<String, CommonConfiguration> CONFIGURATION_MAP = new ConcurrentHashMap();
    public static final List<String> KEYS = Lists.newArrayList((Object[])new String[]{"HTTP", "TCP", "GRPC", "ADMIN"});

    public static void putIfAbsent(String key, CommonConfiguration configuration) {
        if (Objects.isNull(configuration)) {
            return;
        }
        CONFIGURATION_MAP.putIfAbsent(key, configuration);
    }

    public static CommonConfiguration get(String key) {
        return CONFIGURATION_MAP.get(key);
    }

    public static void clear() {
        CONFIGURATION_MAP.clear();
    }
}

