/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.config.ConfigInfo;
import org.apache.eventmesh.common.config.convert.Convert;

public interface FileLoad {
    public static final PropertiesFileLoad PROPERTIES_FILE_LOAD = new PropertiesFileLoad();
    public static final YamlFileLoad YAML_FILE_LOAD = new YamlFileLoad();

    public static FileLoad getFileLoad(String fileType) {
        if (StringUtils.equals((CharSequence)"properties", (CharSequence)fileType)) {
            return PROPERTIES_FILE_LOAD;
        }
        if (StringUtils.equals((CharSequence)"yaml", (CharSequence)fileType)) {
            return YAML_FILE_LOAD;
        }
        return PROPERTIES_FILE_LOAD;
    }

    public static PropertiesFileLoad getPropertiesFileLoad() {
        return PROPERTIES_FILE_LOAD;
    }

    public static YamlFileLoad getYamlFileLoad() {
        return YAML_FILE_LOAD;
    }

    public <T> T getConfig(ConfigInfo var1) throws IOException;

    public static class YamlFileLoad
    implements FileLoad {
        /*
         * Exception decompiling
         */
        @Override
        public <T> T getConfig(ConfigInfo configInfo) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class PropertiesFileLoad
    implements FileLoad {
        private final Convert convert = new Convert();

        @Override
        public <T> T getConfig(ConfigInfo configInfo) throws IOException {
            Properties properties = new Properties();
            if (StringUtils.isNotBlank((CharSequence)configInfo.getResourceUrl())) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream(configInfo.getResourceUrl())), Constants.DEFAULT_CHARSET));){
                    properties.load(reader);
                }
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(configInfo.getFilePath(), new String[0]), new OpenOption[0]), Constants.DEFAULT_CHARSET));){
                properties.load(reader);
            }
            if (Objects.isNull(configInfo.getClazz())) {
                return (T)properties;
            }
            return (T)this.convert.doConvert(configInfo, properties);
        }

        public <T> T getConfig(Properties properties, ConfigInfo configInfo) {
            return (T)this.convert.doConvert(configInfo, properties);
        }
    }
}

