/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.source;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSourceIncrementConfig;
import org.apache.eventmesh.connector.canal.CanalConnectRecord;
import org.apache.eventmesh.connector.canal.model.EventColumn;
import org.apache.eventmesh.connector.canal.model.EventColumnIndexComparable;
import org.apache.eventmesh.connector.canal.model.EventType;
import org.apache.eventmesh.connector.canal.source.table.RdbTableMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EntryParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntryParser.class);

    public static Map<Long, List<CanalConnectRecord>> parse(CanalSourceIncrementConfig sourceConfig, List<CanalEntry.Entry> datas, RdbTableMgr tables) {
        ArrayList<CanalConnectRecord> recordList = new ArrayList<CanalConnectRecord>();
        ArrayList<CanalEntry.Entry> transactionDataBuffer = new ArrayList<CanalEntry.Entry>();
        HashMap<Long, List<CanalConnectRecord>> recordMap = new HashMap<Long, List<CanalConnectRecord>>();
        try {
            for (CanalEntry.Entry entry : datas) {
                switch (entry.getEntryType()) {
                    case ROWDATA: {
                        CanalEntry.RowChange rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
                        if (sourceConfig.getServerUUID() != null && sourceConfig.isGTIDMode() && !sourceConfig.isMariaDB()) {
                            if (!EntryParser.checkGtidForEntry(entry, sourceConfig)) break;
                            transactionDataBuffer.add(entry);
                            break;
                        }
                        boolean needSync = EntryParser.checkNeedSync(sourceConfig, rowChange);
                        if (!needSync) break;
                        log.debug("entry evenType {}|rowChange {}", (Object)rowChange.getEventType(), (Object)rowChange);
                        transactionDataBuffer.add(entry);
                        break;
                    }
                    case TRANSACTIONEND: {
                        EntryParser.parseRecordListWithEntryBuffer(sourceConfig, recordList, transactionDataBuffer, tables);
                        if (!recordList.isEmpty()) {
                            ArrayList<CanalConnectRecord> transactionEndList = new ArrayList<CanalConnectRecord>(recordList);
                            recordMap.put(entry.getHeader().getLogfileOffset(), transactionEndList);
                        }
                        recordList.clear();
                        transactionDataBuffer.clear();
                        break;
                    }
                }
            }
            EntryParser.parseRecordListWithEntryBuffer(sourceConfig, recordList, transactionDataBuffer, tables);
            if (!recordList.isEmpty()) {
                ArrayList<CanalConnectRecord> transactionEndList = new ArrayList<CanalConnectRecord>(recordList);
                CanalConnectRecord lastCanalConnectRecord = (CanalConnectRecord)transactionEndList.get(transactionEndList.size() - 1);
                recordMap.put(lastCanalConnectRecord.getBinLogOffset(), transactionEndList);
            }
            recordList.clear();
            transactionDataBuffer.clear();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return recordMap;
    }

    private static boolean checkGtidForEntry(CanalEntry.Entry entry, CanalSourceIncrementConfig sourceConfig) {
        String currentGtid = ((CanalEntry.Pair)entry.getHeader().getPropsList().get(0)).getValue();
        return currentGtid.contains(sourceConfig.getServerUUID());
    }

    private static void parseRecordListWithEntryBuffer(CanalSourceIncrementConfig sourceConfig, List<CanalConnectRecord> recordList, List<CanalEntry.Entry> transactionDataBuffer, RdbTableMgr tables) {
        for (CanalEntry.Entry bufferEntry : transactionDataBuffer) {
            List<CanalConnectRecord> recordParsedList = EntryParser.internParse(sourceConfig, bufferEntry, tables);
            if (CollectionUtils.isEmpty(recordParsedList)) continue;
            long totalSize = bufferEntry.getHeader().getEventLength();
            long eachSize = totalSize / (long)recordParsedList.size();
            for (CanalConnectRecord record : recordParsedList) {
                if (record == null) continue;
                record.setSize(eachSize);
                recordList.add(record);
            }
        }
    }

    private static boolean checkNeedSync(CanalSourceIncrementConfig sourceConfig, CanalEntry.RowChange rowChange) {
        CanalEntry.Column markedColumn = null;
        CanalEntry.EventType eventType = rowChange.getEventType();
        if (StringUtils.isEmpty((CharSequence)sourceConfig.getNeedSyncMarkTableColumnName())) {
            return true;
        }
        if (eventType.equals((Object)CanalEntry.EventType.DELETE)) {
            markedColumn = EntryParser.getColumnIgnoreCase(rowChange.getRowDatas(0).getBeforeColumnsList(), sourceConfig.getNeedSyncMarkTableColumnName());
        } else if (eventType.equals((Object)CanalEntry.EventType.INSERT) || eventType.equals((Object)CanalEntry.EventType.UPDATE)) {
            markedColumn = EntryParser.getColumnIgnoreCase(rowChange.getRowDatas(0).getAfterColumnsList(), sourceConfig.getNeedSyncMarkTableColumnName());
        }
        if (markedColumn != null) {
            return StringUtils.equalsIgnoreCase((CharSequence)markedColumn.getValue(), (CharSequence)sourceConfig.getNeedSyncMarkTableColumnValue());
        }
        return false;
    }

    private static CanalEntry.Column getColumnIgnoreCase(List<CanalEntry.Column> columns, String columName) {
        for (CanalEntry.Column column : columns) {
            if (!column.getName().equalsIgnoreCase(columName)) continue;
            return column;
        }
        return null;
    }

    private static List<CanalConnectRecord> internParse(CanalSourceIncrementConfig sourceConfig, CanalEntry.Entry entry, RdbTableMgr tableMgr) {
        String tableName;
        String schemaName = entry.getHeader().getSchemaName();
        if (tableMgr.getTable(schemaName, tableName = entry.getHeader().getTableName()) == null) {
            return null;
        }
        CanalEntry.RowChange rowChange = null;
        try {
            rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
        }
        catch (Exception e) {
            throw new RuntimeException("parser of canal-event has an error , data:" + entry.toString(), e);
        }
        if (rowChange == null) {
            return null;
        }
        EventType eventType = EventType.valueOf(rowChange.getEventType().name());
        if (eventType.isQuery()) {
            return null;
        }
        if (eventType.isDdl()) {
            log.warn("unsupported ddl event type: {}", (Object)eventType);
            return null;
        }
        ArrayList<CanalConnectRecord> recordList = new ArrayList<CanalConnectRecord>();
        for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
            CanalConnectRecord record = EntryParser.internParse(sourceConfig, entry, rowChange, rowData);
            recordList.add(record);
        }
        return recordList;
    }

    private static CanalConnectRecord internParse(CanalSourceIncrementConfig canalSourceConfig, CanalEntry.Entry entry, CanalEntry.RowChange rowChange, CanalEntry.RowData rowData) {
        CanalConnectRecord canalConnectRecord = new CanalConnectRecord();
        canalConnectRecord.setTableName(entry.getHeader().getTableName());
        canalConnectRecord.setSchemaName(entry.getHeader().getSchemaName());
        canalConnectRecord.setEventType(EventType.valueOf(rowChange.getEventType().name()));
        canalConnectRecord.setExecuteTime(entry.getHeader().getExecuteTime());
        canalConnectRecord.setJournalName(entry.getHeader().getLogfileName());
        canalConnectRecord.setBinLogOffset(entry.getHeader().getLogfileOffset());
        if (canalSourceConfig.isGTIDMode()) {
            String currentGtid;
            if (canalSourceConfig.isMariaDB()) {
                currentGtid = entry.getHeader().getGtid();
                canalConnectRecord.setGtid(currentGtid);
                canalConnectRecord.setCurrentGtid(currentGtid);
            } else {
                currentGtid = ((CanalEntry.Pair)entry.getHeader().getPropsList().get(0)).getValue();
                String gtidRange = EntryParser.replaceGtidRange(entry.getHeader().getGtid(), currentGtid, canalSourceConfig.getServerUUID());
                canalConnectRecord.setGtid(gtidRange);
                canalConnectRecord.setCurrentGtid(currentGtid);
            }
        }
        EventType eventType = canalConnectRecord.getEventType();
        List beforeColumns = rowData.getBeforeColumnsList();
        List afterColumns = rowData.getAfterColumnsList();
        boolean isRowMode = canalSourceConfig.getSyncMode().isRow();
        LinkedHashMap<String, EventColumn> keyColumns = new LinkedHashMap<String, EventColumn>();
        LinkedHashMap<String, EventColumn> oldKeyColumns = new LinkedHashMap<String, EventColumn>();
        LinkedHashMap<String, EventColumn> notKeyColumns = new LinkedHashMap<String, EventColumn>();
        if (eventType.isInsert()) {
            for (CanalEntry.Column column : afterColumns) {
                if (column.getIsKey()) {
                    keyColumns.put(column.getName(), EntryParser.copyEventColumn(column, true));
                    continue;
                }
                notKeyColumns.put(column.getName(), EntryParser.copyEventColumn(column, true));
            }
        } else if (eventType.isDelete()) {
            for (CanalEntry.Column column : beforeColumns) {
                if (column.getIsKey()) {
                    keyColumns.put(column.getName(), EntryParser.copyEventColumn(column, true));
                    continue;
                }
                notKeyColumns.put(column.getName(), EntryParser.copyEventColumn(column, true));
            }
        } else if (eventType.isUpdate()) {
            for (CanalEntry.Column column : beforeColumns) {
                if (column.getIsKey()) {
                    oldKeyColumns.put(column.getName(), EntryParser.copyEventColumn(column, true));
                    keyColumns.put(column.getName(), EntryParser.copyEventColumn(column, true));
                    continue;
                }
                if (!isRowMode || entry.getHeader().getSourceType() != CanalEntry.Type.ORACLE) continue;
                notKeyColumns.put(column.getName(), EntryParser.copyEventColumn(column, true));
            }
            for (CanalEntry.Column column : afterColumns) {
                if (column.getIsKey()) {
                    keyColumns.put(column.getName(), EntryParser.copyEventColumn(column, true));
                    continue;
                }
                if (!isRowMode && entry.getHeader().getSourceType() != CanalEntry.Type.ORACLE && !column.getUpdated()) continue;
                boolean isUpdate = true;
                if (entry.getHeader().getSourceType() == CanalEntry.Type.MYSQL) {
                    isUpdate = column.getUpdated();
                }
                notKeyColumns.put(column.getName(), EntryParser.copyEventColumn(column, isUpdate));
            }
            if (entry.getHeader().getSourceType() == CanalEntry.Type.ORACLE) {
                EntryParser.checkUpdateKeyColumns(oldKeyColumns, keyColumns);
            }
        }
        ArrayList<EventColumn> keys = new ArrayList<EventColumn>(keyColumns.values());
        ArrayList<EventColumn> oldKeys = new ArrayList<EventColumn>(oldKeyColumns.values());
        ArrayList<EventColumn> columns = new ArrayList<EventColumn>(notKeyColumns.values());
        keys.sort(new EventColumnIndexComparable());
        oldKeys.sort(new EventColumnIndexComparable());
        columns.sort(new EventColumnIndexComparable());
        if (!keyColumns.isEmpty()) {
            canalConnectRecord.setKeys(keys);
            if (canalConnectRecord.getEventType().isUpdate() && !oldKeys.equals(keys)) {
                canalConnectRecord.setOldKeys(oldKeys);
            }
        } else {
            throw new RuntimeException("this row data has no pks , entry: " + entry + " and rowData: " + rowData);
        }
        canalConnectRecord.setColumns(columns);
        return canalConnectRecord;
    }

    public static String replaceGtidRange(String gtid, String currentGtid, String serverUUID) {
        CharSequence[] gtidRangeArray = gtid.split(",");
        for (int i = 0; i < gtidRangeArray.length; ++i) {
            String gtidRange = gtidRangeArray[i];
            if (!gtidRange.startsWith(serverUUID)) continue;
            gtidRangeArray[i] = gtidRange.replaceFirst("\\d+$", currentGtid.split(":")[1]);
        }
        return String.join((CharSequence)",", gtidRangeArray);
    }

    private static void checkUpdateKeyColumns(Map<String, EventColumn> oldKeyColumns, Map<String, EventColumn> keyColumns) {
        if (oldKeyColumns.isEmpty()) {
            return;
        }
        if (keyColumns.size() > oldKeyColumns.size()) {
            return;
        }
        if (keyColumns.isEmpty()) {
            keyColumns.putAll(oldKeyColumns);
            return;
        }
        if (oldKeyColumns.size() != keyColumns.size()) {
            for (String oldKey : oldKeyColumns.keySet()) {
                if (keyColumns.get(oldKey) != null) continue;
                keyColumns.put(oldKey, oldKeyColumns.get(oldKey));
            }
        }
    }

    private static EventColumn copyEventColumn(CanalEntry.Column column, boolean isUpdate) {
        EventColumn eventColumn = new EventColumn();
        eventColumn.setIndex(column.getIndex());
        eventColumn.setKey(column.getIsKey());
        eventColumn.setNull(column.getIsNull());
        eventColumn.setColumnName(column.getName());
        eventColumn.setColumnValue(column.getValue());
        eventColumn.setUpdate(isUpdate);
        eventColumn.setColumnType(column.getSqlType());
        return eventColumn;
    }
}

