/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.sink;

import java.util.ArrayList;
import java.util.List;
import org.apache.eventmesh.connector.canal.CanalConnectRecord;
import org.apache.eventmesh.connector.canal.model.EventType;

public class DbLoadData {
    private List<TableLoadData> tables = new ArrayList<TableLoadData>();

    public DbLoadData() {
    }

    public DbLoadData(List<CanalConnectRecord> records) {
        for (CanalConnectRecord record : records) {
            this.merge(record);
        }
    }

    public void merge(CanalConnectRecord record) {
        TableLoadData tableData = this.findTableData(record);
        EventType type = record.getEventType();
        if (type.isInsert()) {
            tableData.getInsertDatas().add(record);
        } else if (type.isUpdate()) {
            tableData.getUpdateDatas().add(record);
        } else if (type.isDelete()) {
            tableData.getDeleteDatas().add(record);
        }
    }

    public List<TableLoadData> getTables() {
        return this.tables;
    }

    private synchronized TableLoadData findTableData(CanalConnectRecord record) {
        for (TableLoadData table : this.tables) {
            if (!table.getSchemaName().equals(record.getSchemaName()) || !table.getTableName().equals(record.getTableName())) continue;
            return table;
        }
        TableLoadData data = new TableLoadData(record.getSchemaName(), record.getTableName());
        this.tables.add(data);
        return data;
    }

    public static class TableLoadData {
        private String schemaName;
        private String tableName;
        private List<CanalConnectRecord> insertDatas = new ArrayList<CanalConnectRecord>();
        private List<CanalConnectRecord> upadateDatas = new ArrayList<CanalConnectRecord>();
        private List<CanalConnectRecord> deleteDatas = new ArrayList<CanalConnectRecord>();

        public TableLoadData(String schemaName, String tableName) {
            this.schemaName = schemaName;
            this.tableName = tableName;
        }

        public List<CanalConnectRecord> getInsertDatas() {
            return this.insertDatas;
        }

        public void setInsertDatas(List<CanalConnectRecord> insertDatas) {
            this.insertDatas = insertDatas;
        }

        public List<CanalConnectRecord> getUpdateDatas() {
            return this.upadateDatas;
        }

        public void setUpdateDatas(List<CanalConnectRecord> upadateDatas) {
            this.upadateDatas = upadateDatas;
        }

        public List<CanalConnectRecord> getDeleteDatas() {
            return this.deleteDatas;
        }

        public void setDeleteDatas(List<CanalConnectRecord> deleteDatas) {
            this.deleteDatas = deleteDatas;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }
    }
}

