/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class UnknownPropertyDetectionAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        if (delegate instanceof ReflectiveTypeAdapterFactory.Adapter) {
            try {
                Class<?> adaptorClass = delegate.getClass();
                Field fieldsDataField = null;
                while (fieldsDataField == null && !adaptorClass.equals(Object.class)) {
                    try {
                        fieldsDataField = adaptorClass.getDeclaredField("fieldsData");
                    }
                    catch (NoSuchFieldException _ignore) {
                        adaptorClass = adaptorClass.getSuperclass();
                    }
                }
                if (fieldsDataField == null) {
                    String message = "Failed to access fieldsData inside the GSON library";
                    throw new IllegalStateException(message);
                }
                fieldsDataField.setAccessible(true);
                Object fieldData = fieldsDataField.get(delegate);
                Field deserializedFieldsField = fieldData.getClass().getDeclaredField("deserializedFields");
                deserializedFieldsField.setAccessible(true);
                Map deserializedFields = (Map)deserializedFieldsField.get(fieldData);
                StringBuilder sb = new StringBuilder();
                for (String key : deserializedFields.keySet()) {
                    sb.append(key + ", ");
                }
                final String boundFieldsStr = sb.append("... (" + type.getType().getTypeName() + ")").toString();
                deserializedFields = new LinkedHashMap<String, Object>(deserializedFields){

                    @Override
                    public Object get(Object key) {
                        Object value = super.get(key);
                        if (value == null) {
                            throw new JsonParseException("Unknown property detected: " + key + " in " + boundFieldsStr);
                        }
                        return value;
                    }
                };
                deserializedFieldsField.set(fieldData, deserializedFields);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return delegate;
    }
}

