/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.concurrent.ExecutorServiceFactory;
import io.pravega.common.concurrent.ThreadPoolScheduledExecutorService;
import io.pravega.common.function.RunnableWithException;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceHelpers {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceHelpers.class);
    private static final ExecutorServiceFactory FACTORY = new ExecutorServiceFactory();

    public static ThreadFactory getThreadFactory(String groupName) {
        return FACTORY.getThreadFactory(groupName);
    }

    public static ThreadFactory getThreadFactory(String groupName, int priority) {
        return FACTORY.getThreadFactory(groupName, priority);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int size, String poolName) {
        return ExecutorServiceHelpers.newScheduledThreadPool(size, poolName, 5);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int size, String poolName, int threadPriority) {
        return FACTORY.newScheduledThreadPool(size, poolName, threadPriority);
    }

    public static Snapshot getSnapshot(ExecutorService service) {
        Preconditions.checkNotNull((Object)service, (Object)"service");
        if (service instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)service;
            return new Snapshot(tpe.getQueue().size(), tpe.getActiveCount(), tpe.getPoolSize());
        }
        if (service instanceof ForkJoinPool) {
            ForkJoinPool fjp = (ForkJoinPool)service;
            return new Snapshot(fjp.getQueuedSubmissionCount(), fjp.getActiveThreadCount(), fjp.getPoolSize());
        }
        if (service instanceof ThreadPoolScheduledExecutorService) {
            ThreadPoolScheduledExecutorService tpse = (ThreadPoolScheduledExecutorService)service;
            return new Snapshot(tpse.getRunner().getQueue().size(), tpse.getRunner().getActiveCount(), tpse.getRunner().getPoolSize());
        }
        return null;
    }

    public static ExecutorService getShrinkingExecutor(int maxThreadCount, int threadTimeout, String poolName) {
        return FACTORY.newShrinkingExecutor(maxThreadCount, threadTimeout, poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(RunnableWithException task, Consumer<Throwable> exceptionHandler, Runnable runFinally, Executor executor) {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull(exceptionHandler, (Object)"exceptionHandler");
        Preconditions.checkNotNull((Object)runFinally, (Object)"runFinally");
        boolean scheduledSuccess = false;
        try {
            executor.execute(() -> {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    if (!Exceptions.mustRethrow(ex)) {
                        exceptionHandler.accept(ex);
                    }
                }
                finally {
                    runFinally.run();
                }
            });
            scheduledSuccess = true;
        }
        finally {
            if (!scheduledSuccess) {
                runFinally.run();
            }
        }
    }

    public static void shutdown(ExecutorService ... pools) {
        ExecutorServiceHelpers.shutdown(Duration.ofSeconds(5L), pools);
    }

    public static void shutdown(Duration timeout, ExecutorService ... pools) {
        for (ExecutorService pool : pools) {
            pool.shutdown();
        }
        TimeoutTimer timer = new TimeoutTimer(timeout);
        for (ExecutorService pool : pools) {
            try {
                if (pool.awaitTermination(timer.getRemaining().toMillis(), TimeUnit.MILLISECONDS)) continue;
                pool.shutdownNow();
                if (pool.awaitTermination(timer.getRemaining().toMillis(), TimeUnit.MILLISECONDS)) continue;
                List<Runnable> remainingTasks = pool.shutdownNow();
                log.warn("One or more threads from pool " + pool + " did not shutdown properly. Waiting tasks: " + remainingTasks);
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class Snapshot {
        final int queueSize;
        final int activeThreadCount;
        final int poolSize;

        @ConstructorProperties(value={"queueSize", "activeThreadCount", "poolSize"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Snapshot(int queueSize, int activeThreadCount, int poolSize) {
            this.queueSize = queueSize;
            this.activeThreadCount = activeThreadCount;
            this.poolSize = poolSize;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getQueueSize() {
            return this.queueSize;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getActiveThreadCount() {
            return this.activeThreadCount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getPoolSize() {
            return this.poolSize;
        }
    }
}

