/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.protobuf.ProtoDataWrapper;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import io.cloudevents.v1.proto.CloudEvent;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

class ProtoDeserializer
implements CloudEventReader {
    private final CloudEvent protoCe;

    public ProtoDeserializer(CloudEvent protoCe) {
        this.protoCe = protoCe;
    }

    public <W extends CloudEventWriter<R>, R> R read(CloudEventWriterFactory<W, R> writerFactory, CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException {
        SpecVersion specVersion = SpecVersion.parse((String)this.protoCe.getSpecVersion());
        CloudEventWriter writer = writerFactory.create(specVersion);
        writer.withContextAttribute("id", this.protoCe.getId());
        writer.withContextAttribute("source", this.protoCe.getSource());
        writer.withContextAttribute("type", this.protoCe.getType());
        for (Map.Entry<String, CloudEvent.CloudEventAttributeValue> entry : this.protoCe.getAttributesMap().entrySet()) {
            String name = entry.getKey();
            CloudEvent.CloudEventAttributeValue val = entry.getValue();
            switch (val.getAttrCase()) {
                case CE_BOOLEAN: {
                    writer.withContextAttribute(name, Boolean.valueOf(val.getCeBoolean()));
                    break;
                }
                case CE_INTEGER: {
                    writer.withContextAttribute(name, Integer.valueOf(val.getCeInteger()));
                    break;
                }
                case CE_STRING: {
                    writer.withContextAttribute(name, val.getCeString());
                    break;
                }
                case CE_BYTES: {
                    writer.withContextAttribute(name, val.getCeBytes().toByteArray());
                    break;
                }
                case CE_URI: {
                    writer.withContextAttribute(name, URI.create(val.getCeUri()));
                    break;
                }
                case CE_URI_REF: {
                    writer.withContextAttribute(name, URI.create(val.getCeUriRef()));
                    break;
                }
                case CE_TIMESTAMP: {
                    Timestamp timestamp = val.getCeTimestamp();
                    writer.withContextAttribute(name, this.covertProtoTimestamp(timestamp));
                    break;
                }
            }
        }
        ProtoDataWrapper data = null;
        byte[] raw = null;
        switch (this.protoCe.getDataCase()) {
            case BINARY_DATA: {
                raw = this.protoCe.getBinaryData().toByteArray();
                data = BytesCloudEventData.wrap((byte[])raw);
                break;
            }
            case TEXT_DATA: {
                raw = this.protoCe.getTextData().getBytes(StandardCharsets.UTF_8);
                data = BytesCloudEventData.wrap((byte[])raw);
                break;
            }
            case PROTO_DATA: {
                data = new ProtoDataWrapper((Message)this.protoCe.getProtoData());
                break;
            }
        }
        if (data != null) {
            return (R)writer.end(mapper.map(data));
        }
        return (R)writer.end();
    }

    private OffsetDateTime covertProtoTimestamp(Timestamp timestamp) {
        Instant instant = Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        return instant.atOffset(ZoneOffset.UTC);
    }
}

