/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.connection.impl.RawClient;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.NoSuchSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentSealedException;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.Retry;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.WireCommandType;
import io.pravega.shared.protocol.netty.WireCommands;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeEventWriter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LargeEventWriter.class);
    private static final int WRITE_SIZE = 0x800000;
    @Nonnull
    private final UUID writerId;
    @Nonnull
    private final Controller controller;
    @Nonnull
    private final ConnectionPool connectionPool;

    public void writeLargeEvent(Segment segment, List<ByteBuffer> events, DelegationTokenProvider tokenProvider, EventWriterConfig config) throws NoSuchSegmentException, AuthenticationException, SegmentSealedException {
        List<ByteBuf> payloads = this.createBufs(events);
        int attempts = 1 + Math.max(0, config.getRetryAttempts());
        Retry.withExpBackoff((long)config.getInitialBackoffMillis(), (int)config.getBackoffMultiple(), (int)attempts, (long)config.getMaxBackoffMillis()).retryWhen(t -> {
            Throwable ex = Exceptions.unwrap((Throwable)t);
            if (ex instanceof ConnectionFailedException) {
                log.info("Connection failure while sending large event: {}. Retrying", (Object)ex.getMessage());
                return true;
            }
            if (ex instanceof TokenExpiredException) {
                tokenProvider.signalTokenExpired();
                log.info("Authentication token expired while writing large event to segment {}. Retrying", (Object)segment);
                return true;
            }
            return false;
        }).run(() -> {
            RawClient client = new RawClient(this.controller, this.connectionPool, segment);
            try {
                this.write(segment, payloads, client, tokenProvider);
                Object var5_5 = null;
                return var5_5;
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        });
    }

    private List<ByteBuf> createBufs(List<ByteBuffer> events) {
        ByteBuffer[] toWrite = new ByteBuffer[2 * events.size()];
        for (int i = 0; i < events.size(); ++i) {
            ByteBuffer event = events.get(i);
            byte[] header = new byte[8];
            ByteBuffer wrapped = ByteBuffer.wrap(header);
            wrapped.putInt(WireCommandType.EVENT.getCode());
            wrapped.putInt(event.remaining());
            wrapped.flip();
            toWrite[2 * i] = wrapped;
            toWrite[2 * i + 1] = event;
        }
        ByteBuf master = Unpooled.wrappedBuffer((ByteBuffer[])toWrite);
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>();
        while (master.isReadable()) {
            int toRead = Math.min(master.readableBytes(), 0x800000);
            result.add(master.readSlice(toRead));
        }
        return result;
    }

    private void write(Segment parentSegment, List<ByteBuf> payloads, RawClient client, DelegationTokenProvider tokenProvider) throws TokenExpiredException, NoSuchSegmentException, AuthenticationException, SegmentSealedException, ConnectionFailedException {
        int i;
        long requestId = client.getFlow().getNextSequenceNumber();
        log.debug("Writing large event to segment {} with writer id {}", (Object)parentSegment, (Object)this.writerId);
        String token = (String)Futures.getThrowingException(tokenProvider.retrieveToken());
        WireCommands.CreateTransientSegment createSegment = new WireCommands.CreateTransientSegment(requestId, this.writerId, parentSegment.getScopedName(), token);
        WireCommands.SegmentCreated created = this.transformSegmentCreated((Reply)Futures.getThrowingException(client.sendRequest(requestId, createSegment)), parentSegment.getScopedName());
        requestId = client.getFlow().getNextSequenceNumber();
        WireCommands.SetupAppend setup = new WireCommands.SetupAppend(requestId, this.writerId, created.getSegment(), token);
        WireCommands.AppendSetup appendSetup = this.transformAppendSetup((Reply)Futures.getThrowingException(client.sendRequest(requestId, setup)), created.getSegment());
        if (appendSetup.getLastEventNumber() != Long.MIN_VALUE) {
            throw new IllegalStateException("Server indicates that transient segment was already written to: " + created.getSegment());
        }
        long expectedOffset = 0L;
        ArrayList<CompletableFuture<Reply>> futures = new ArrayList<CompletableFuture<Reply>>();
        for (i = 0; i < payloads.size(); ++i) {
            requestId = client.getFlow().getNextSequenceNumber();
            ByteBuf payload = payloads.get(i);
            WireCommands.ConditionalBlockEnd request = new WireCommands.ConditionalBlockEnd(this.writerId, (long)i, expectedOffset, Unpooled.wrappedBuffer((ByteBuf)payload), requestId);
            expectedOffset += (long)payload.readableBytes();
            CompletableFuture<Reply> reply = client.sendRequest(requestId, request);
            this.failFast(futures, created.getSegment());
            futures.add(reply);
        }
        for (i = 0; i < futures.size(); ++i) {
            this.transformDataAppended((Reply)Futures.getThrowingException((Future)((Future)futures.get(i))), created.getSegment());
        }
        requestId = client.getFlow().getNextSequenceNumber();
        WireCommands.MergeSegments merge = new WireCommands.MergeSegments(requestId, parentSegment.getScopedName(), created.getSegment(), token);
        this.transformSegmentMerged((Reply)Futures.getThrowingException(client.sendRequest(requestId, merge)), created.getSegment());
    }

    private void failFast(ArrayList<CompletableFuture<Reply>> futures, String segmentId) throws TokenExpiredException, NoSuchSegmentException, AuthenticationException, SegmentSealedException, ConnectionFailedException {
        for (CompletableFuture<Reply> future : futures) {
            if (!future.isDone()) break;
            this.transformDataAppended((Reply)Futures.getThrowingException(future), segmentId);
        }
    }

    private WireCommands.SegmentCreated transformSegmentCreated(Reply reply, String segmentId) throws TokenExpiredException, NoSuchSegmentException, AuthenticationException, SegmentSealedException, ConnectionFailedException {
        if (reply instanceof WireCommands.SegmentCreated) {
            return (WireCommands.SegmentCreated)reply;
        }
        throw this.handleUnexpectedReply(reply, "SegmentCreated", segmentId);
    }

    private WireCommands.AppendSetup transformAppendSetup(Reply reply, String segmentId) throws TokenExpiredException, NoSuchSegmentException, AuthenticationException, SegmentSealedException, ConnectionFailedException {
        if (reply instanceof WireCommands.AppendSetup) {
            return (WireCommands.AppendSetup)reply;
        }
        throw this.handleUnexpectedReply(reply, "AppendSetup", segmentId);
    }

    private Void transformDataAppended(Reply reply, String segmentId) throws TokenExpiredException, NoSuchSegmentException, AuthenticationException, SegmentSealedException, ConnectionFailedException {
        if (reply instanceof WireCommands.DataAppended) {
            return null;
        }
        throw this.handleUnexpectedReply(reply, "DataAppended", segmentId);
    }

    private WireCommands.SegmentsMerged transformSegmentMerged(Reply reply, String segmentId) throws TokenExpiredException, NoSuchSegmentException, AuthenticationException, SegmentSealedException, ConnectionFailedException {
        if (reply instanceof WireCommands.SegmentsMerged) {
            return (WireCommands.SegmentsMerged)reply;
        }
        throw this.handleUnexpectedReply(reply, "MergeSegments", segmentId);
    }

    @VisibleForTesting
    RuntimeException handleUnexpectedReply(Reply reply, String expectation, String segmentId) throws NoSuchSegmentException, SegmentSealedException, TokenExpiredException, AuthenticationException, ConnectionFailedException {
        log.warn("Unexpected reply {} observed instead of {} for conditional writer {} for {}", new Object[]{reply, expectation, this.writerId, segmentId});
        if (reply instanceof WireCommands.NoSuchSegment) {
            throw new NoSuchSegmentException(reply.toString());
        }
        if (reply instanceof WireCommands.SegmentIsSealed) {
            throw new SegmentSealedException(reply.toString());
        }
        if (reply instanceof WireCommands.WrongHost) {
            throw new ConnectionFailedException(reply.toString());
        }
        if (reply instanceof WireCommands.AuthTokenCheckFailed) {
            WireCommands.AuthTokenCheckFailed authTokenCheckFailed = (WireCommands.AuthTokenCheckFailed)reply;
            if (authTokenCheckFailed.isTokenExpired()) {
                throw new TokenExpiredException(authTokenCheckFailed.getServerStackTrace());
            }
            throw new AuthenticationException(authTokenCheckFailed.toString());
        }
        if (reply instanceof WireCommands.OperationUnsupported) {
            throw new UnsupportedOperationException("Attempted to write a large append on segment " + segmentId + " to a server version which only supports appends < 8 MB.");
        }
        if (reply instanceof WireCommands.ConditionalCheckFailed | reply instanceof WireCommands.InvalidEventNumber | reply instanceof WireCommands.SegmentIsTruncated | reply instanceof WireCommands.SegmentAlreadyExists) {
            log.error("Failure: " + reply + " while appending to transient segment: " + segmentId + ". This indicates a bug, but the request will be retried.");
            throw new ConnectionFailedException("Server state error");
        }
        throw new ConnectionFailedException("Unexpected reply of " + reply + " when expecting an " + expectation);
    }

    @ConstructorProperties(value={"writerId", "controller", "connectionPool"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LargeEventWriter(@Nonnull UUID writerId, @Nonnull Controller controller, @Nonnull ConnectionPool connectionPool) {
        if (writerId == null) {
            throw new NullPointerException("writerId is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (connectionPool == null) {
            throw new NullPointerException("connectionPool is marked non-null but is null");
        }
        this.writerId = writerId;
        this.controller = controller;
        this.connectionPool = connectionPool;
    }
}

