/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import lombok.Generated;

public class JavaSerializer<T extends Serializable>
implements Serializer<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public ByteBuffer serialize(T value) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(value);
            oout.close();
            bout.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    @Override
    public T deserialize(ByteBuffer serializedValue) {
        ByteArrayInputStream bin = new ByteArrayInputStream(serializedValue.array(), serializedValue.position(), serializedValue.remaining());
        try {
            ObjectInputStream oin = new ObjectInputStream(bin);
            return (T)((Serializable)oin.readObject());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaSerializer)) {
            return false;
        }
        JavaSerializer other = (JavaSerializer)o;
        return other.canEqual(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JavaSerializer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

