/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import io.pravega.client.stream.impl.StreamCutInternal;
import io.pravega.common.util.ByteBufferUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;

public interface StreamCut
extends Serializable {
    public static final StreamCut UNBOUNDED = new StreamCut(){
        private static final long serialVersionUID = 1L;

        @Override
        public ByteBuffer toBytes() {
            return ByteBufferUtils.EMPTY;
        }

        @Override
        public String asText() {
            return this.toString();
        }

        @Override
        public StreamCutInternal asImpl() {
            return null;
        }

        public String toString() {
            return "UNBOUNDED";
        }

        private Object readResolve() {
            return UNBOUNDED;
        }
    };

    public StreamCutInternal asImpl();

    public ByteBuffer toBytes();

    public String asText();

    public static StreamCut from(String base64String) {
        if (base64String.equals(UNBOUNDED.asText())) {
            return UNBOUNDED;
        }
        return StreamCutInternal.from(base64String);
    }

    public static StreamCut fromBytes(ByteBuffer cut) {
        if (!cut.hasRemaining()) {
            return UNBOUNDED;
        }
        return StreamCutInternal.fromBytes(cut);
    }
}

