/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.connection.impl.ConnectionFactory;
import io.pravega.client.connection.impl.ConnectionPoolImpl;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.state.InitialUpdate;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.state.SynchronizerConfig;
import io.pravega.client.state.Update;
import io.pravega.client.stream.ConfigMismatchException;
import io.pravega.client.stream.InvalidStreamException;
import io.pravega.client.stream.ReaderGroup;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.ReaderGroupNotFoundException;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.impl.AbstractClientFactoryImpl;
import io.pravega.client.stream.impl.ClientFactoryImpl;
import io.pravega.client.stream.impl.ReaderGroupImpl;
import io.pravega.client.stream.impl.ReaderGroupState;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.shared.NameUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderGroupManagerImpl
implements ReaderGroupManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReaderGroupManagerImpl.class);
    private final String scope;
    @VisibleForTesting
    private final AbstractClientFactoryImpl clientFactory;
    private final Controller controller;

    public ReaderGroupManagerImpl(String scope, ClientConfig config, ConnectionFactory connectionFactory) {
        this.scope = scope;
        this.controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor());
        ConnectionPoolImpl connectionPool = new ConnectionPoolImpl(config, connectionFactory);
        this.clientFactory = new ClientFactoryImpl(scope, this.controller, connectionPool);
    }

    public ReaderGroupManagerImpl(String scope, Controller controller, AbstractClientFactoryImpl clientFactory) {
        this.scope = scope;
        this.clientFactory = clientFactory;
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createReaderGroup(String groupName, ReaderGroupConfig config) throws ConfigMismatchException {
        ReaderGroupConfig controllerConfig;
        log.info("Creating reader group: {} for streams: {} with configuration: {}", new Object[]{groupName, Arrays.toString(config.getStartingStreamCuts().keySet().toArray()), config});
        NameUtils.validateReaderGroupName((String)groupName);
        if (config.getReaderGroupId() == ReaderGroupConfig.DEFAULT_UUID) {
            config = ReaderGroupConfig.cloneConfig(config, UUID.randomUUID(), 0L);
        }
        if (!(controllerConfig = (ReaderGroupConfig)Futures.getThrowingException(this.controller.createReaderGroup(this.scope, groupName, config))).equals(config)) {
            log.warn("ReaderGroup {} already exists with pre-existing configuration {}", (Object)groupName, (Object)controllerConfig);
            throw new ConfigMismatchException(groupName, controllerConfig);
        }
        if (controllerConfig.getGeneration() > 0L) {
            log.info("ReaderGroup {} already exists", (Object)groupName);
            return false;
        }
        StateSynchronizer<ReaderGroupState> synchronizer = this.clientFactory.createStateSynchronizer(NameUtils.getStreamForReaderGroup((String)groupName), new ReaderGroupStateUpdatesSerializer(), new ReaderGroupStateInitSerializer(), SynchronizerConfig.builder().build());
        try {
            Map<SegmentWithRange, Long> segments = ReaderGroupImpl.getSegmentsForStreams(this.controller, controllerConfig);
            synchronizer.initialize(new ReaderGroupState.ReaderGroupStateInit(controllerConfig, segments, ReaderGroupImpl.getEndSegmentsForStreams(controllerConfig), false));
            boolean bl = true;
            return bl;
        }
        finally {
            if (Collections.singletonList(synchronizer).get(0) != null) {
                synchronizer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteReaderGroup(String groupName) {
        UUID readerGroupId;
        block8: {
            readerGroupId = null;
            ReaderGroupConfig syncConfig = null;
            try {
                StateSynchronizer synchronizer = this.clientFactory.createStateSynchronizer(NameUtils.getStreamForReaderGroup((String)groupName), new ReaderGroupStateUpdatesSerializer(), new ReaderGroupStateInitSerializer(), SynchronizerConfig.builder().build());
                try {
                    synchronizer.fetchUpdates();
                    syncConfig = ((ReaderGroupState)synchronizer.getState()).getConfig();
                    readerGroupId = syncConfig.getReaderGroupId();
                    if (!ReaderGroupConfig.DEFAULT_UUID.equals(syncConfig.getReaderGroupId()) || -1L != syncConfig.getGeneration()) break block8;
                    try {
                        ((CompletableFuture)this.controller.getReaderGroupConfig(this.scope, groupName).thenCompose(conf -> this.controller.deleteReaderGroup(this.scope, groupName, conf.getReaderGroupId()))).join();
                    }
                    catch (ReaderGroupNotFoundException ex) {
                        ((CompletableFuture)((CompletableFuture)this.controller.sealStream(this.scope, NameUtils.getStreamForReaderGroup((String)groupName)).thenCompose(b -> this.controller.deleteStream(this.scope, NameUtils.getStreamForReaderGroup((String)groupName)))).exceptionally(e -> {
                            log.warn("Failed to delete ReaderGroup Stream {}", (Object)NameUtils.getStreamForReaderGroup((String)groupName), e);
                            throw Exceptions.sneakyThrow((Throwable)e);
                        })).join();
                    }
                    return;
                }
                finally {
                    if (Collections.singletonList(synchronizer).get(0) != null) {
                        synchronizer.close();
                    }
                }
            }
            catch (InvalidStreamException ex) {
                log.warn("State-Synchronizer Stream for ReaderGroup {} was not found.", (Object)NameUtils.getScopedReaderGroupName((String)this.scope, (String)groupName));
                readerGroupId = ((ReaderGroupConfig)Futures.getAndHandleExceptions(this.controller.getReaderGroupConfig(this.scope, groupName), RuntimeException::new)).getReaderGroupId();
            }
        }
        Futures.getAndHandleExceptions(this.controller.deleteReaderGroup(this.scope, groupName, readerGroupId), RuntimeException::new);
    }

    @Override
    public ReaderGroup getReaderGroup(String groupName) throws ReaderGroupNotFoundException {
        SynchronizerConfig synchronizerConfig = SynchronizerConfig.builder().build();
        try {
            return new ReaderGroupImpl(this.scope, groupName, synchronizerConfig, new ReaderGroupStateInitSerializer(), new ReaderGroupStateUpdatesSerializer(), this.clientFactory, this.controller, this.clientFactory.getConnectionPool());
        }
        catch (InvalidStreamException e) {
            throw new ReaderGroupNotFoundException(groupName, e);
        }
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    AbstractClientFactoryImpl getClientFactory() {
        return this.clientFactory;
    }

    @VisibleForTesting
    public static class ReaderGroupStateUpdatesSerializer
    implements Serializer<Update<ReaderGroupState>> {
        private final ReaderGroupState.ReaderGroupUpdateSerializer serializer = new ReaderGroupState.ReaderGroupUpdateSerializer();

        @Override
        public ByteBuffer serialize(Update<ReaderGroupState> value) {
            ByteArraySegment serialized = this.serializer.serialize(value);
            return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
        }

        @Override
        public Update<ReaderGroupState> deserialize(ByteBuffer serializedValue) {
            return (Update)this.serializer.deserialize((ArrayView)new ByteArraySegment(serializedValue));
        }
    }

    @VisibleForTesting
    public static class ReaderGroupStateInitSerializer
    implements Serializer<InitialUpdate<ReaderGroupState>> {
        private final ReaderGroupState.ReaderGroupInitSerializer serializer = new ReaderGroupState.ReaderGroupInitSerializer();

        @Override
        public ByteBuffer serialize(InitialUpdate<ReaderGroupState> value) {
            ByteArraySegment serialized = this.serializer.serialize(value);
            return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
        }

        @Override
        public InitialUpdate<ReaderGroupState> deserialize(ByteBuffer serializedValue) {
            return (InitialUpdate)this.serializer.deserialize((ArrayView)new ByteArraySegment(serializedValue));
        }
    }
}

