/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive.storage;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.apache.eventmesh.webhook.api.utils.ClassUtils;
import org.apache.eventmesh.webhook.receive.config.ReceiveConfiguration;
import org.apache.eventmesh.webhook.receive.storage.WebhookFileListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookConfigOperationManager
implements WebHookConfigOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookConfigOperationManager.class);
    private final transient Map<String, WebHookConfig> cacheWebHookConfig = new ConcurrentHashMap<String, WebHookConfig>();
    private transient String operationMode;
    private transient ConfigService nacosConfigService;

    public HookConfigOperationManager() {
    }

    public HookConfigOperationManager(ReceiveConfiguration receiveConfiguration) throws NacosException {
        switch (this.operationMode = receiveConfiguration.getOperationMode()) {
            case "file": {
                new WebhookFileListener(receiveConfiguration.getFilePath(), this.cacheWebHookConfig);
                break;
            }
            case "nacos": {
                this.nacosModeInit(receiveConfiguration.getOperationProperties());
                break;
            }
        }
    }

    private void nacosModeInit(Properties config) throws NacosException {
        this.nacosConfigService = ConfigFactory.createConfigService((Properties)config);
    }

    public WebHookConfig queryWebHookConfigById(WebHookConfig webHookConfig) {
        switch (this.operationMode) {
            case "file": {
                return this.cacheWebHookConfig.get(ClassUtils.convertResourcePathToClassName((String)webHookConfig.getCallbackPath()));
            }
            case "nacos": {
                try {
                    String content = this.nacosConfigService.getConfig(webHookConfig.getManufacturerEventName() + ".json", "webhook_" + webHookConfig.getManufacturerName(), 3000L);
                    return (WebHookConfig)JsonUtils.parseObject((String)content, WebHookConfig.class);
                }
                catch (NacosException e) {
                    log.error("queryWebHookConfigById failed", (Throwable)e);
                    break;
                }
            }
        }
        return null;
    }

    public List<WebHookConfig> queryWebHookConfigByManufacturer(WebHookConfig webHookConfig, Integer pageNum, Integer pageSize) {
        return new ArrayList<WebHookConfig>();
    }

    public Integer insertWebHookConfig(WebHookConfig webHookConfig) {
        this.cacheWebHookConfig.put(webHookConfig.getCallbackPath(), webHookConfig);
        return 1;
    }

    public Integer updateWebHookConfig(WebHookConfig webHookConfig) {
        this.cacheWebHookConfig.put(webHookConfig.getCallbackPath(), webHookConfig);
        return 1;
    }

    public Integer deleteWebHookConfig(WebHookConfig webHookConfig) {
        this.cacheWebHookConfig.remove(webHookConfig.getCallbackPath());
        return 1;
    }
}

