/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.util.internal.StackTraceSimplifier;

public class DefaultExceptionEvent
implements ExceptionEvent {
    private final Channel channel;
    private final Throwable cause;

    public DefaultExceptionEvent(Channel channel, Throwable cause) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        this.channel = channel;
        this.cause = cause;
        StackTraceSimplifier.simplify(cause);
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return this.getChannel().toString() + " EXCEPTION: " + this.cause;
    }
}

