/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.ssl.MyX509TrustManager;
import org.apache.eventmesh.client.http.util.HttpLoadBalanceUtils;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClient.class);
    protected EventMeshHttpClientConfig eventMeshHttpClientConfig;
    protected LoadBalanceSelector<String> eventMeshServerSelector;
    protected final CloseableHttpClient httpClient;

    public AbstractHttpClient(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        Objects.requireNonNull(eventMeshHttpClientConfig, "liteClientConfig can't be null");
        Objects.requireNonNull(eventMeshHttpClientConfig.getLiteEventMeshAddr(), "liteServerAddr can't be null");
        this.eventMeshHttpClientConfig = eventMeshHttpClientConfig;
        this.eventMeshServerSelector = HttpLoadBalanceUtils.createEventMeshServerLoadBalanceSelector(eventMeshHttpClientConfig);
        this.httpClient = this.setHttpClient();
    }

    @Override
    public void close() throws EventMeshException {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                throw new EventMeshException((Throwable)e);
            }
        }
    }

    private CloseableHttpClient setHttpClient() throws EventMeshException {
        if (!this.eventMeshHttpClientConfig.isUseTls()) {
            return HttpClients.createDefault();
        }
        try {
            String protocol = this.eventMeshHttpClientConfig.getSslClientProtocol();
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, tm, new SecureRandom());
            return HttpClients.custom().setConnectionManager(this.getHttpPoolManager(sslContext, this.eventMeshHttpClientConfig.getMaxConnectionPoolSize())).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).evictIdleConnections((long)this.eventMeshHttpClientConfig.getConnectionIdleTimeSeconds(), TimeUnit.SECONDS).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy()).build();
        }
        catch (Exception e) {
            log.error("Error in creating HttpClient.", (Throwable)e);
            throw new EventMeshException((Throwable)e);
        }
    }

    private HttpClientConnectionManager getHttpPoolManager(SSLContext sslContext, int poolSize) {
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(poolSize);
        return connectionManager;
    }

    protected String selectEventMesh() {
        if (this.eventMeshHttpClientConfig.isUseTls()) {
            return "https://" + (String)this.eventMeshServerSelector.select();
        }
        return "http://" + (String)this.eventMeshServerSelector.select();
    }
}

