/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.banner;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.common.banner.PinpointBanner;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class PinpointBannerImpl
extends PinpointBanner {
    private final BootLogger logger;
    private Properties properties;

    public PinpointBannerImpl(List<String> keysToPrint, BootLogger logger) {
        this.setPinpointBannerMode(PinpointBanner.Mode.CONSOLE);
        this.logger = Objects.requireNonNull(logger, "logger");
        this.setKeysToPrint(Objects.requireNonNull(keysToPrint, "keysToPrint"));
    }

    public void setPinpointBannerProperty(Properties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    public void printBanner() {
        if (this.properties == null) {
            this.logger.warn("Property not ready for Pinpoint Banner");
            return;
        }
        switch (this.getPinpointBannerMode()) {
            case OFF: {
                return;
            }
            case LOG: {
                this.logger.info(this.buildBannerString());
                return;
            }
        }
        System.out.println(this.buildBannerString());
    }

    private String buildBannerString() {
        StringBuilder sb = new StringBuilder();
        for (String line : BANNER) {
            sb.append(line).append(System.lineSeparator());
        }
        sb.append(this.format("Pinpoint Version", "3.0.0")).append(System.lineSeparator());
        for (String key : this.getKeysToPrint()) {
            String value = this.properties.getProperty(key);
            if (value == null) continue;
            sb.append(this.format(key, value)).append('\n');
        }
        return sb.toString();
    }
}

