/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.agentdir.AgentDirBaseClassPathResolver;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAgentPathResolver {
    private final AgentPathFinder[] agentPathFinders;

    JavaAgentPathResolver(AgentPathFinder[] agentPathFinders) {
        this.agentPathFinders = Objects.requireNonNull(agentPathFinders, "agentPathFinders");
    }

    public static JavaAgentPathResolver newJavaAgentPathResolver() {
        AgentPathFinder[] agentPathFinders = JavaAgentPathResolver.newAgentPathFinder();
        return new JavaAgentPathResolver(agentPathFinders);
    }

    private static AgentPathFinder[] newAgentPathFinder() {
        ClassAgentPathFinder classAgentPath = new ClassAgentPathFinder();
        InputArgumentAgentPathFinder inputArgumentAgentPath = new InputArgumentAgentPathFinder();
        return new AgentPathFinder[]{classAgentPath, inputArgumentAgentPath};
    }

    public Path resolveJavaAgentPath() {
        for (AgentPathFinder agentPath : this.agentPathFinders) {
            Path path = agentPath.getPath();
            if (path == null) continue;
            return path;
        }
        return null;
    }

    @Deprecated
    static class InputArgumentAgentPathFinder
    implements AgentPathFinder {
        private final BootLogger logger = BootLogger.getLogger(this.getClass());
        static final String JAVA_AGENT_OPTION = "-javaagent:";
        private final Pattern DEFAULT_AGENT_PATTERN = AgentDirBaseClassPathResolver.bootstrap.getVersionPattern();

        InputArgumentAgentPathFinder() {
        }

        @Override
        public Path getPath() {
            List<String> inputArguments = this.getInputArguments();
            for (String inputArgument : inputArguments) {
                if (!this.isPinpointAgent(inputArgument, this.DEFAULT_AGENT_PATTERN)) continue;
                String agentPath = this.removeJavaAgentPrefix(inputArgument);
                this.logger.info("agentPath:" + agentPath);
                return Paths.get(agentPath, new String[0]);
            }
            return null;
        }

        @VisibleForTesting
        List<String> getInputArguments() {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            return runtimeMXBean.getInputArguments();
        }

        private boolean isPinpointAgent(String inputArgument, Pattern javaPattern) {
            if (!inputArgument.startsWith(JAVA_AGENT_OPTION)) {
                return false;
            }
            Matcher matcher = javaPattern.matcher(inputArgument);
            return matcher.find();
        }

        private String removeJavaAgentPrefix(String inputArgument) {
            return inputArgument.substring(JAVA_AGENT_OPTION.length());
        }
    }

    static class ClassAgentPathFinder
    implements AgentPathFinder {
        private final BootLogger logger = BootLogger.getLogger(this.getClass());
        private final String className;

        public ClassAgentPathFinder() {
            this("com.navercorp.pinpoint.bootstrap.PinpointBootStrap");
        }

        public ClassAgentPathFinder(String className) {
            this.className = className;
        }

        @Override
        public Path getPath() {
            String jarLocation = this.getJarLocation(this.className);
            this.logger.info("agentPath:" + jarLocation);
            return Paths.get(URI.create(jarLocation));
        }

        @VisibleForTesting
        String getJarLocation(String className) {
            String internalClassName = className.replace('.', '/') + ".class";
            URL classURL = this.getResource(internalClassName);
            if (classURL == null) {
                return null;
            }
            if (classURL.getProtocol().equals("jar")) {
                String path = classURL.getPath();
                int jarIndex = path.indexOf("!/");
                if (jarIndex == -1) {
                    throw new IllegalArgumentException("!/ not found " + path);
                }
                String agentPath = path.substring(0, jarIndex);
                return agentPath;
            }
            return null;
        }

        private URL getResource(String internalClassName) {
            return ClassLoader.getSystemResource(internalClassName);
        }
    }

    static interface AgentPathFinder {
        public Path getPath();
    }
}

