/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.agentdir.BootDir;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AgentDirectory {
    public static final String AGENT_ROOT_PATH_KEY = "pinpoint.agent.root.path";
    public static final Path LIB_DIR = Paths.get("lib", new String[0]);
    public static final Path PLUGIN_DIR = Paths.get("plugin", new String[0]);
    public static final Path LOGS_DIR = Paths.get("logs", new String[0]);
    public static final Path PROFILES_DIR = Paths.get("profiles", new String[0]);
    private final Path agentJarName;
    private final Path agentJarFullPath;
    private final Path agentDirPath;
    private final BootDir bootDir;
    private final List<Path> plugins;
    private final List<Path> libs;

    public AgentDirectory(Path agentJarName, Path agentJarFullPath, Path agentDirPath, BootDir bootDir, List<Path> libs, List<Path> plugins) {
        this.agentJarName = agentJarName;
        this.agentJarFullPath = agentJarFullPath;
        this.agentDirPath = agentDirPath;
        this.bootDir = Objects.requireNonNull(bootDir, "bootDir");
        this.libs = libs;
        this.plugins = plugins;
    }

    public BootDir getBootDir() {
        return this.bootDir;
    }

    public List<Path> getLibs() {
        return this.libs;
    }

    public List<Path> getPlugins() {
        return this.plugins;
    }

    public Path getAgentJarName() {
        return this.agentJarName;
    }

    public Path getAgentJarFullPath() {
        return this.agentJarFullPath;
    }

    public Path getAgentDirPath() {
        return this.agentDirPath;
    }

    public Path getAgentLibPath() {
        return this.appendAgentDirPath(LIB_DIR);
    }

    public Path getAgentLogFilePath() {
        return this.appendAgentDirPath(LOGS_DIR);
    }

    public Path getAgentPluginPath() {
        return this.appendAgentDirPath(PLUGIN_DIR);
    }

    public Path getAgentConfigPath() {
        return this.appendAgentDirPath(Paths.get("pinpoint-root.config", new String[0]));
    }

    public Path getProfilesPath() {
        return this.appendAgentDirPath(PROFILES_DIR);
    }

    private Path appendAgentDirPath(Path fileName) {
        return this.agentDirPath.resolve(fileName);
    }

    public String[] getProfileDirs() {
        ArrayList<String> fileList = new ArrayList<String>();
        Path profilesPath = this.getProfilesPath();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(profilesPath);){
            for (Path path : stream) {
                Path fileName;
                if (!path.toFile().isDirectory() || (fileName = path.getFileName()) == null) continue;
                fileList.add(fileName.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("profileDirs traverse error " + profilesPath, e);
        }
        return fileList.toArray(new String[0]);
    }
}

