/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.socket_mode.impl;

import com.google.gson.Gson;
import com.slack.api.Slack;
import com.slack.api.methods.SlackApiException;
import com.slack.api.socket_mode.SocketModeClient;
import com.slack.api.socket_mode.listener.EnvelopeListener;
import com.slack.api.socket_mode.listener.WebSocketCloseListener;
import com.slack.api.socket_mode.listener.WebSocketErrorListener;
import com.slack.api.socket_mode.listener.WebSocketMessageListener;
import com.slack.api.socket_mode.queue.SocketModeMessageQueue;
import com.slack.api.socket_mode.queue.impl.ConcurrentLinkedMessageQueue;
import com.slack.api.socket_mode.request.EventsApiEnvelope;
import com.slack.api.socket_mode.request.InteractiveEnvelope;
import com.slack.api.socket_mode.request.SlashCommandsEnvelope;
import com.slack.api.util.http.ProxyUrlUtil;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;

@ClientEndpoint
public class SocketModeClientTyrusImpl
implements SocketModeClient {
    private Slack slack;
    private String appToken;
    private final Gson gson;
    private URI wssUri;
    private boolean autoReconnectEnabled;
    private boolean autoReconnectOnCloseEnabled;
    private SocketModeMessageQueue messageQueue;
    private ScheduledExecutorService messageProcessorExecutor;
    private boolean sessionMonitorEnabled;
    private Optional<ScheduledExecutorService> sessionMonitorExecutor;
    private AtomicReference<String> latestPong = new AtomicReference();
    private final List<WebSocketMessageListener> webSocketMessageListeners = new CopyOnWriteArrayList<WebSocketMessageListener>();
    private final List<EnvelopeListener<EventsApiEnvelope>> eventsApiEnvelopeListeners = new CopyOnWriteArrayList<EnvelopeListener<EventsApiEnvelope>>();
    private final List<EnvelopeListener<SlashCommandsEnvelope>> slashCommandsEnvelopeListeners = new CopyOnWriteArrayList<EnvelopeListener<SlashCommandsEnvelope>>();
    private final List<EnvelopeListener<InteractiveEnvelope>> interactiveEnvelopeListeners = new CopyOnWriteArrayList<EnvelopeListener<InteractiveEnvelope>>();
    private final List<WebSocketErrorListener> webSocketErrorListeners = new CopyOnWriteArrayList<WebSocketErrorListener>();
    private final List<WebSocketCloseListener> webSocketCloseListeners = new CopyOnWriteArrayList<WebSocketCloseListener>();
    private Session currentSession;
    private final ExecutorService sessionCleanerExecutor;

    public SocketModeClientTyrusImpl(String appToken) throws URISyntaxException, IOException, SlackApiException {
        this(Slack.getInstance(), appToken);
    }

    public SocketModeClientTyrusImpl(Slack slack, String appToken) throws URISyntaxException, IOException, SlackApiException {
        this(slack, appToken, slack.methods(appToken).appsConnectionsOpen(r -> r).getUrl());
    }

    public SocketModeClientTyrusImpl(Slack slack, String appToken, String wssUrl) throws URISyntaxException {
        this(slack, appToken, wssUrl, 10);
    }

    public SocketModeClientTyrusImpl(Slack slack, String appToken, String wssUrl, int concurrency) throws URISyntaxException {
        this(slack, appToken, wssUrl, concurrency, new ConcurrentLinkedMessageQueue(), true, true, 5000L);
    }

    public SocketModeClientTyrusImpl(Slack slack, String appToken, String wssUrl, int concurrency, SocketModeMessageQueue messageQueue, boolean autoReconnectEnabled, boolean sessionMonitorEnabled, long sessionMonitorIntervalMillis) throws URISyntaxException {
        if (wssUrl == null) {
            throw new IllegalArgumentException("The wss URL for using Socket Mode is absent.");
        }
        this.setSlack(slack);
        this.setAppToken(appToken);
        this.setWssUri(new URI(wssUrl));
        this.gson = GsonFactory.createSnakeCase(slack.getConfig());
        this.setMessageQueue(messageQueue);
        this.setAutoReconnectEnabled(autoReconnectEnabled);
        this.setAutoReconnectOnCloseEnabled(false);
        this.setSessionMonitorEnabled(sessionMonitorEnabled);
        this.initializeSessionMonitorExecutor(sessionMonitorIntervalMillis);
        this.initializeMessageProcessorExecutor(concurrency);
        this.sessionCleanerExecutor = slack.getConfig().getExecutorServiceProvider().createThreadPoolExecutor(this.getExecutorGroupNamePrefix() + "-session-cleaner", 3);
    }

    @Override
    public long maintainCurrentSession() {
        if (this.isAutoReconnectEnabled() && !this.verifyConnection()) {
            this.getLogger().info("The current session is no longer active. Going to reconnect to the Socket Mode server.");
            try {
                this.connectToNewEndpoint();
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to connect to a new Socket Mode server endpoint: {}", (Object)e.getMessage(), (Object)e);
                return System.currentTimeMillis() + 10000L;
            }
        }
        return System.currentTimeMillis();
    }

    @Override
    public void connect() {
        try {
            ClientManager clientManager = ClientManager.createClient();
            Map<String, String> proxyHeaders = this.getSlack().getHttpClient().getConfig().getProxyHeaders();
            String proxyUrl = this.getSlack().getHttpClient().getConfig().getProxyUrl();
            if (proxyUrl != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("The SocketMode client's going to use an HTTP proxy: {}", (Object)proxyUrl);
                }
                ProxyUrlUtil.ProxyUrl parsedProxy = ProxyUrlUtil.parse(proxyUrl);
                clientManager.getProperties().put("org.glassfish.tyrus.client.proxy", parsedProxy.toUrlWithoutUserAndPassword());
                if (parsedProxy.getUsername() != null && parsedProxy.getPassword() != null) {
                    if (proxyHeaders == null) {
                        proxyHeaders = new HashMap<String, String>();
                    }
                    ProxyUrlUtil.setProxyAuthorizationHeader(proxyHeaders, parsedProxy);
                }
            }
            if (proxyHeaders != null && !proxyHeaders.isEmpty()) {
                clientManager.getProperties().put("org.glassfish.tyrus.client.proxy.headers", proxyHeaders);
            }
            try {
                this.setAutoReconnectEnabled(true);
                Session newSession = clientManager.connectToServer((Object)this, this.getWssUri());
                this.setCurrentSession(newSession);
            }
            catch (DeploymentException e) {
                throw new IOException(e);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("This Socket Mode client is successfully connected to the server: {}", (Object)this.getWssUri());
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to reconnect to Socket Mode server: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public boolean verifyConnection() {
        if (this.currentSession != null && this.currentSession.isOpen()) {
            String ping = "ping-pong_" + this.currentSession.getId();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Sending a ping message: {}", (Object)ping);
            }
            ByteBuffer pingBytes = ByteBuffer.wrap(ping.getBytes());
            try {
                RemoteEndpoint.Basic basicRemote = this.currentSession.getBasicRemote();
                this.latestPong.set(null);
                basicRemote.sendPing(pingBytes);
                for (long waitMillis = 0L; waitMillis <= 3000L; waitMillis += 100L) {
                    String pong = this.latestPong.getAndSet(null);
                    if (pong != null && pong.equals(ping)) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Received a pong message: {}", (Object)ping);
                        }
                        return true;
                    }
                    basicRemote.sendPing(pingBytes);
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to send a ping message (session id: {}, error: {})", (Object)this.currentSession.getId(), (Object)e.getMessage());
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to receive a pong message: {}", (Object)ping);
            }
        }
        return false;
    }

    @Override
    public boolean isAutoReconnectOnCloseEnabled() {
        return this.autoReconnectOnCloseEnabled;
    }

    @Override
    public void setAutoReconnectOnCloseEnabled(boolean autoReconnectOnCloseEnabled) {
        this.autoReconnectOnCloseEnabled = autoReconnectOnCloseEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        this.setAutoReconnectEnabled(false);
        if (this.currentSession != null) {
            Session session = this.currentSession;
            synchronized (session) {
                SocketModeClientTyrusImpl.closeSession(this.currentSession);
            }
        }
    }

    @OnOpen
    public void onOpen(Session session) {
        this.getLogger().info("New session is open (session id: {})", (Object)session.getId());
        if (this.verifyConnection()) {
            this.setCurrentSession(session);
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        this.getLogger().info("onClose listener is called (session id: {}, reason: {})", (Object)session.getId(), (Object)reason.getReasonPhrase());
        this.runCloseListenersAndAutoReconnectAsNecessary(reason.getCloseCode().getCode(), reason.getReasonPhrase());
    }

    @OnError
    public void onError(Session session, Throwable reason) {
        this.getLogger().error("onError listener is called (session id: {}, reason: {})", (Object)session.getId(), (Object)reason);
        this.runErrorListeners(reason);
    }

    @OnMessage
    public void onMessage(String message) {
        this.enqueueMessage(message);
    }

    @OnMessage
    public void onPong(PongMessage message) {
        this.latestPong.set(new String(message.getApplicationData().array()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentSession(Session newSession) {
        if (this.currentSession == null) {
            this.currentSession = newSession;
        } else {
            Session session = this.currentSession;
            synchronized (session) {
                if (this.currentSession.getId().equals(newSession.getId())) {
                    return;
                }
                Session oldSession = this.currentSession;
                this.sessionCleanerExecutor.execute(() -> {
                    try {
                        SocketModeClientTyrusImpl.closeSession(oldSession);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Failed to close an old session (session id: {}, exception: {})", new Object[]{oldSession.getId(), e.getMessage(), e});
                    }
                });
                this.currentSession = newSession;
            }
        }
    }

    private static void closeSession(Session session) throws IOException {
        if (session.isOpen()) {
            CloseReason.CloseCodes code = CloseReason.CloseCodes.NORMAL_CLOSURE;
            String phrase = SocketModeClientTyrusImpl.class.getCanonicalName() + " did it";
            session.close(new CloseReason((CloseReason.CloseCode)code, phrase));
        }
    }

    @Override
    public Slack getSlack() {
        return this.slack;
    }

    @Override
    public void setSlack(Slack slack) {
        this.slack = slack;
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public String getAppToken() {
        return this.appToken;
    }

    @Override
    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    @Override
    public boolean isAutoReconnectEnabled() {
        return this.autoReconnectEnabled;
    }

    @Override
    public void setAutoReconnectEnabled(boolean autoReconnectEnabled) {
        this.autoReconnectEnabled = autoReconnectEnabled;
    }

    @Override
    public boolean isSessionMonitorEnabled() {
        return this.sessionMonitorEnabled;
    }

    @Override
    public void setSessionMonitorEnabled(boolean sessionMonitorEnabled) {
        this.sessionMonitorEnabled = sessionMonitorEnabled;
    }

    @Override
    public Optional<ScheduledExecutorService> getSessionMonitorExecutor() {
        return this.sessionMonitorExecutor;
    }

    @Override
    public void sendWebSocketMessage(String message) {
        this.currentSession.getAsyncRemote().sendText(message);
    }

    @Override
    public URI getWssUri() {
        return this.wssUri;
    }

    @Override
    public void setWssUri(URI wssUri) {
        this.wssUri = wssUri;
    }

    @Override
    public SocketModeMessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public void setMessageQueue(SocketModeMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public ScheduledExecutorService getMessageProcessorExecutor() {
        return this.messageProcessorExecutor;
    }

    @Override
    public void setMessageProcessorExecutor(ScheduledExecutorService executorService) {
        this.messageProcessorExecutor = executorService;
    }

    @Override
    public void setSessionMonitorExecutor(Optional<ScheduledExecutorService> executorService) {
        this.sessionMonitorExecutor = executorService;
    }

    @Override
    public List<WebSocketMessageListener> getWebSocketMessageListeners() {
        return this.webSocketMessageListeners;
    }

    @Override
    public List<WebSocketErrorListener> getWebSocketErrorListeners() {
        return this.webSocketErrorListeners;
    }

    @Override
    public List<WebSocketCloseListener> getWebSocketCloseListeners() {
        return this.webSocketCloseListeners;
    }

    @Override
    public List<EnvelopeListener<InteractiveEnvelope>> getInteractiveEnvelopeListeners() {
        return this.interactiveEnvelopeListeners;
    }

    @Override
    public List<EnvelopeListener<SlashCommandsEnvelope>> getSlashCommandsEnvelopeListeners() {
        return this.slashCommandsEnvelopeListeners;
    }

    @Override
    public List<EnvelopeListener<EventsApiEnvelope>> getEventsApiEnvelopeListeners() {
        return this.eventsApiEnvelopeListeners;
    }
}

