/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.audit;

import com.slack.api.SlackConfig;
import com.slack.api.audit.AuditApiErrorResponse;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditApiException
extends Exception {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditApiException.class);
    private final Response response;
    private final String responseBody;
    private final AuditApiErrorResponse error;

    public AuditApiException(Response response, String responseBody) {
        this(SlackConfig.DEFAULT, response, responseBody);
    }

    public AuditApiException(SlackConfig config, Response response, String responseBody) {
        this(response, responseBody, AuditApiException.parse(config, responseBody));
    }

    public AuditApiException(Response response, String responseBody, AuditApiErrorResponse error) {
        super(AuditApiException.buildErrorMessage(response, error));
        this.response = response;
        this.responseBody = responseBody;
        this.error = error;
    }

    private static String buildErrorMessage(Response response, AuditApiErrorResponse error) {
        String message = "status: " + response.code();
        if (error != null) {
            return message + ", error: " + error.getError() + ", needed: " + error.getNeeded() + ", warning: " + error.getProvided() + ", warning: " + error.getWarning();
        }
        return message + ", no response body";
    }

    private static AuditApiErrorResponse parse(SlackConfig config, String responseBody) {
        AuditApiErrorResponse parsedErrorResponse;
        block2: {
            parsedErrorResponse = null;
            try {
                parsedErrorResponse = (AuditApiErrorResponse)GsonFactory.createSnakeCase(config).fromJson(responseBody, AuditApiErrorResponse.class);
                parsedErrorResponse.setRawBody(responseBody);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                String responseToPrint = responseBody.length() > 1000 ? responseBody.subSequence(0, 1000) + " ..." : responseBody;
                log.debug("Failed to parse the error response body: {}", (Object)responseToPrint);
            }
        }
        return parsedErrorResponse;
    }

    @Generated
    public Response getResponse() {
        return this.response;
    }

    @Generated
    public String getResponseBody() {
        return this.responseBody;
    }

    @Generated
    public AuditApiErrorResponse getError() {
        return this.error;
    }

    @Override
    @Generated
    public String toString() {
        return "AuditApiException(response=" + this.getResponse() + ", responseBody=" + this.getResponseBody() + ", error=" + this.getError() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditApiException)) {
            return false;
        }
        AuditApiException other = (AuditApiException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        AuditApiErrorResponse this$error = this.getError();
        AuditApiErrorResponse other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuditApiException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        AuditApiErrorResponse $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }
}

