/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.mysql.NumberType;

public class DecimalType
extends NumberType<Double> {
    public static final DecimalType INSTANCE = new DecimalType();

    public DecimalType() {
        super(Double.class, SQLType.DOUBLE, "DECIMAL");
    }

    @Override
    public String getTypeName(Column<?> column) {
        StringBuilder typeNameBuilder = new StringBuilder();
        Long length = Optional.ofNullable(column.getColumnLength()).orElse(10L);
        if (column.getDecimal() == null) {
            typeNameBuilder.append("DECIMAL(" + length + ")");
        } else {
            String typeName = this.hibernateDialect.getTypeName(column.getJdbcType().getVendorTypeNumber().intValue(), length.longValue(), length.intValue(), Optional.ofNullable(column.getDecimal()).orElse(0).intValue());
            typeNameBuilder.append(typeName);
        }
        typeNameBuilder.append(this.convertOptions2Sql(column));
        return typeNameBuilder.toString();
    }

    @Override
    public List<String> ofRegistrationKeys() {
        return Arrays.asList("decimal", this.getName());
    }
}

